# 💫 V4.17.0: New Features: Simplified Chart Language Support and Enhanced `get_settings` Function

New Features: Simplified Chart Language Support and Enhanced `get_settings` Function

### Chart Language Support

I have added a new feature in the charts functionality: **chart_language**. You can now set the language for the chart, making it more accessible and user-friendly for non-English speakers. The default language is English (EN).

#### Available Languages:

- EN (English)
- FR (French)
- PT (Portuguese)
- ES (Spanish)
- TR (Turkish)
- RU (Russian)
- IT (Italian)
- CN (Chinese)
- DE (German)

To set the language for your chart, simply use the [`chart_language`] parameter.

Eg:

```python
from kerykeion import AstrologicalSubject, KerykeionChartSVG

# Italian Language Chart
italian_subject = AstrologicalSubject("Sofia Loren", 1934, 9, 20, 4, 30, "Rome", "IT")
italian_chart = KerykeionChartSVG(italian_subject, chart_language="IT")
italian_chart.makeSVG()
```

### Enhanced `get_settings` Function

I have improved the `get_settings` function to provide more flexibility when retrieving settings.

Now, the function signature has been updated to:

This enhancement allows you to pass a dictionary or an instance of `KerykeionSettingsModel` directly to the function, providing greater flexibility and ease of use.

I hope these new features enhance your experience with the library. As always, I appreciate your feedback and support.

Happy charting! ✨
