# Release Notes

## New Feature: Lunar Nodes (Rahu & Ketu) Support

I'm excited to announce the addition of Lunar Nodes (Rahu & Ketu) support in Kerykeion. This new feature allows you to work with both True and Mean Lunar Nodes in your astrological calculations and charts.

### Available Lunar Nodes

The following Lunar Nodes are now available:

- **True North Lunar Node**: Simply referred to as "true_node" (without the term "north") for backward compatibility.
- **True South Lunar Node**: Referred to as "true_south_node."
- **Mean North Lunar Node**: Referred to as "mean_node" (without the term "north") for backward compatibility.
- **Mean South Lunar Node**: Referred to as "mean_south_node."

### Default Activation

- In instances of the `AstrologicalSubject` class, all Lunar Nodes are active by default.
- In instances of the classes used to generate aspects and SVG charts, only the mean nodes are active by default.

### How to Activate True Nodes

To activate the true nodes in your aspects and SVG charts, you need to edit the configuration file (`kr.config.json`). Here is an example of how to activate the True South Node:

```json
{
  "id": 19,
  "name": "True_South_Node",
  "color": "var(--kerykeion-chart-color-true-node)",
  "is_active": true, // Set to true to activate the true node
  "element_points": 0,
  "related_zodiac_signs": [],
  "label": "True_South_Node"
}
```


I hope this new feature enhances your astrological analysis and charting experience. As always, we appreciate your feedback and support.

Happy charting! ✨
