# Runtime Specification of Active Planets

I'm excited to announce a new feature that allows users to specify active points to be displayed in the generated astrological charts at runtime. This feature provides greater flexibility and customization, enabling users to tailor the charts to their specific needs.

#### New Parameter

The new `active_points` parameter has been added to the `KerykeionChartSVG` class. This parameter allows you to specify which planets and axial cusps should be visible in the generated charts. By default, all planets and axial cusps are active, but you can now customize this list to include only the points you are interested in.

Here's the default list of active points, defined in kerykeion/settings/config_constants.py:

```python
DEFAULT_ACTIVE_POINTS: List[Union[Planet, AxialCusps]] = [
    "Sun",
    "Moon",
    "Mercury",
    "Venus",
    "Mars",
    "Jupiter",
    "Saturn",
    "Uranus",
    "Neptune",
    "Pluto",
    "Mean_Node",
    # "True_Node",
    "Chiron",
    "Ascendant",
    "Medium_Coeli",
    # "Descendant",
    # "Imum_Coeli",
    "Mean_Lilith",
    "Mean_South_Node",
    # "True_South_Node"
]
```

I left the commented-out points in the list to show all the available options.

#### Example Usage

You can now specify which planets and axial cusps are active when generating a chart. Here is an example of how to use this new parameter:

```python
from kerykeion import AstrologicalSubject, KerykeionChartSVG

first = AstrologicalSubject("John Lennon", 1940, 10, 9, 18, 30, "Liverpool", "GB")
second = AstrologicalSubject("Paul McCartney", 1942, 6, 18, 15, 30, "Liverpool", "GB")

# Internal Natal Chart
internal_natal_chart = KerykeionChartSVG(first, active_points=["Sun", "Moon", "Mercury", "Venus", "Mars", "Jupiter", "Saturn", "Uranus", "Neptune", "Pluto", "True_Node", "True_South_Node", "Ascendant", "Medium_Coeli", "Descendant", "Imum_Coeli"])
internal_natal_chart.makeSVG()
```
