# Runtime Specification of Active Points

This new feature allows users to specify the active aspects and their orbs to be displayed in the generated astrological charts at runtime. 

#### New Parameter

The new `active_aspects` parameter has been added to the `KerykeionChartSVG` class. 
It's a list of dictionaries, where each dictionary contains the name of the aspect and the orb for that aspect. 


```python
DEFAULT_ACTIVE_ASPECTS: List[ActiveAspect] = [
    {"name": "conjunction", "orb": 10},
    {"name": "opposition", "orb": 10},
    {"name": "trine", "orb": 8},
    {"name": "sextile", "orb": 6},
    {"name": "square", "orb": 5},
    {"name": "quintile", "orb": 1},
    # {"name": "semi-sextile", "orb": 1},
    # {"name": "semi-square", "orb": 1},
    # {"name": "sesquiquadrate", "orb": 1},
    # {"name": "biquintile", "orb": 1},
    # {"name": "quincunx", "orb": 1},
]
```

I left the commented-out points in the list to show all the available options.


The full list of aspects are defined in `kerykeion/kr_types/kr_literals.py` and at the moment are:

```python
AspectName = Literal[
    "conjunction",
    "semi-sextile",
    "semi-square",
    "sextile",
    "quintile",
    "square",
    "trine",
    "sesquiquadrate",
    "biquintile",
    "quincunx",
    "opposition"
]
```


#### Example Usage

```python
from kerykeion import AstrologicalSubject, KerykeionChartSVG

first = AstrologicalSubject("John Lennon", 1940, 10, 9, 18, 30, "Liverpool", "GB")
second = AstrologicalSubject("Paul McCartney", 1942, 6, 18, 15, 30, "Liverpool", "GB")

# Internal Natal Chart
internal_natal_chart = KerykeionChartSVG(
    first,
    active_aspects=[
        {"name": "conjunction", "orb": 10},
        {"name": "opposition", "orb": 10},
        {"name": "trine", "orb": 8},
        {"name": "sextile", "orb": 6},
        {"name": "square", "orb": 5},
        {"name": "quintile", "orb": 1},
        {"name": "semi-sextile", "orb": 1},
        {"name": "semi-square", "orb": 1},
        {"name": "sesquiquadrate", "orb": 1},
        {"name": "biquintile", "orb": 1},
        {"name": "quincunx", "orb": 1},
    ]
```
