# Kerykeion v5.1.0 — Unified Aspects, Docs refresh, and Report fix

Release date: 2025-10-28

## Highlights

- Unified aspects API: a single cleaned list `aspects` replaces `relevant_aspects` and `all_aspects`.
- Report generation updated to use the unified list (fixes missing aspects in reports).
- Documentation refresh across README and site-docs to reflect the simplified API.
- Backward compatibility: legacy properties still work and map to the unified list.

## 🚀 What changed

### 1) Aspects API simplification

- Before: Aspects models exposed two lists: `all_aspects` (raw) and `relevant_aspects` (filtered).
- Now: There’s a single definitive list: `aspects` (already filtered/cleaned based on your configuration).
- Filtering behavior (including optional `axis_orb_limit`) remains unchanged and is applied internally by the factory.

Why: two lists created confusion and duplicated choices downstream. One authoritative list makes the API clearer and reduces bugs.

Migration:
- Replace usages of `.relevant_aspects` or `.all_aspects` with `.aspects`.
- Example:
  - `len(natal.aspects.relevant_aspects)` -> `len(natal.aspects.aspects)`
  - `len(synastry.aspects.all_aspects)` -> `len(synastry.aspects.aspects)`

Compatibility:
- Legacy properties (`relevant_aspects`, `all_aspects`) are preserved via the backward-compatibility layer and return the same underlying data as `aspects`. They will be removed in v6.

### 2) Report generator fix

- The aspects section previously referenced the old field and could show “No aspects data” or miss entries.
- Updated to read from `aspects`, restoring complete output.

### 3) Documentation refresh

- README “Retrieving Aspects” section updated to use `aspects`.
- site-docs updated (`aspects.md`, `chart_data_factory.md`) to replace `.relevant_aspects`/`.all_aspects` with `.aspects` and align wording.

## 🧩 Notes for developers

- AspectsFactory behavior is unchanged except output fields. The filtering pipeline and settings (including `axis_orb_limit`) remain the same.
- The backward-compat layer (`kerykeion.backword`) maps both legacy properties to `.aspects` to minimize breakages in the short term.

## ✅ Quality gates

- Build/Typecheck: PASS (doc changes only; code compiles as before)
- Tests: PASS (existing aspect-related tests and report tests validated during development)

## 🔧 Migration checklist

- [ ] Replace `.relevant_aspects` with `.aspects`
- [ ] Replace `.all_aspects` with `.aspects`
- [ ] Re-run tests to verify outputs (counts may remain identical; naming changed)

## 📚 Links

- API Reference: https://www.kerykeion.net/pydocs/kerykeion.html
- Changelog: See prior notes in `release_notes/`
