# coding: utf-8

"""
    BIMData API

    BIMData API documentation  # noqa: E501

    OpenAPI spec version: v1
    Contact: contact@bimdata.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from bimdata_api_client.api_client import ApiClient


class CloudApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_cloud(self, cloud, **kwargs):  # noqa: E501
        """create_cloud  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud(cloud, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Cloud cloud: (required)
        :return: Cloud
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_cloud_with_http_info(cloud, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cloud_with_http_info(cloud, **kwargs)  # noqa: E501
            return data

    def create_cloud_with_http_info(self, cloud, **kwargs):  # noqa: E501
        """create_cloud  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_with_http_info(cloud, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Cloud cloud: (required)
        :return: Cloud
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cloud" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud' is set
        if ('cloud' not in local_var_params or
                local_var_params['cloud'] is None):
            raise ValueError("Missing the required parameter `cloud` when calling `create_cloud`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud' in local_var_params:
            body_params = local_var_params['cloud']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cloud',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_cloud_user(self, cloud_pk, invite_user, **kwargs):  # noqa: E501
        """create_cloud_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_user(cloud_pk, invite_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param InviteUser invite_user: (required)
        :return: InviteUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_cloud_user_with_http_info(cloud_pk, invite_user, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cloud_user_with_http_info(cloud_pk, invite_user, **kwargs)  # noqa: E501
            return data

    def create_cloud_user_with_http_info(self, cloud_pk, invite_user, **kwargs):  # noqa: E501
        """create_cloud_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_user_with_http_info(cloud_pk, invite_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param InviteUser invite_user: (required)
        :return: InviteUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'invite_user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cloud_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_cloud_user`")  # noqa: E501
        # verify the required parameter 'invite_user' is set
        if ('invite_user' not in local_var_params or
                local_var_params['invite_user'] is None):
            raise ValueError("Missing the required parameter `invite_user` when calling `create_cloud_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invite_user' in local_var_params:
            body_params = local_var_params['invite_user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/user', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InviteUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cloud_user(self, cloud_pk, id, **kwargs):  # noqa: E501
        """delete_cloud_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cloud_user(cloud_pk, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_cloud_user_with_http_info(cloud_pk, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cloud_user_with_http_info(cloud_pk, id, **kwargs)  # noqa: E501
            return data

    def delete_cloud_user_with_http_info(self, cloud_pk, id, **kwargs):  # noqa: E501
        """delete_cloud_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cloud_user_with_http_info(cloud_pk, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cloud_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_cloud_user`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_cloud_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/user/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_cloud(self, id, cloud, **kwargs):  # noqa: E501
        """full_update_cloud  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_cloud(id, cloud, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param Cloud cloud: (required)
        :return: Cloud
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_cloud_with_http_info(id, cloud, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_cloud_with_http_info(id, cloud, **kwargs)  # noqa: E501
            return data

    def full_update_cloud_with_http_info(self, id, cloud, **kwargs):  # noqa: E501
        """full_update_cloud  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_cloud_with_http_info(id, cloud, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param Cloud cloud: (required)
        :return: Cloud
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'cloud']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_cloud" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_cloud`")  # noqa: E501
        # verify the required parameter 'cloud' is set
        if ('cloud' not in local_var_params or
                local_var_params['cloud'] is None):
            raise ValueError("Missing the required parameter `cloud` when calling `full_update_cloud`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud' in local_var_params:
            body_params = local_var_params['cloud']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cloud',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_cloud_user(self, cloud_pk, id, invite_user, **kwargs):  # noqa: E501
        """full_update_cloud_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_cloud_user(cloud_pk, id, invite_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param InviteUser invite_user: (required)
        :return: InviteUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_cloud_user_with_http_info(cloud_pk, id, invite_user, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_cloud_user_with_http_info(cloud_pk, id, invite_user, **kwargs)  # noqa: E501
            return data

    def full_update_cloud_user_with_http_info(self, cloud_pk, id, invite_user, **kwargs):  # noqa: E501
        """full_update_cloud_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_cloud_user_with_http_info(cloud_pk, id, invite_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param InviteUser invite_user: (required)
        :return: InviteUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'invite_user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_cloud_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_cloud_user`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_cloud_user`")  # noqa: E501
        # verify the required parameter 'invite_user' is set
        if ('invite_user' not in local_var_params or
                local_var_params['invite_user'] is None):
            raise ValueError("Missing the required parameter `invite_user` when calling `full_update_cloud_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invite_user' in local_var_params:
            body_params = local_var_params['invite_user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/user/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InviteUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud(self, id, **kwargs):  # noqa: E501
        """get_cloud  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: Cloud
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cloud_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_cloud_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_cloud  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: Cloud
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_cloud`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cloud',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_size(self, id, **kwargs):  # noqa: E501
        """get_cloud_size  # noqa: E501

        Returns the size of the cloud in Bytes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_size(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cloud_size_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_size_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_cloud_size_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_cloud_size  # noqa: E501

        Returns the size of the cloud in Bytes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_size_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_size" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_cloud_size`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{id}/size', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_user(self, cloud_pk, id, **kwargs):  # noqa: E501
        """get_cloud_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_user(cloud_pk, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cloud_user_with_http_info(cloud_pk, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_user_with_http_info(cloud_pk, id, **kwargs)  # noqa: E501
            return data

    def get_cloud_user_with_http_info(self, cloud_pk, id, **kwargs):  # noqa: E501
        """get_cloud_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_user_with_http_info(cloud_pk, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_cloud_user`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_cloud_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/user/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='User',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_users(self, cloud_pk, **kwargs):  # noqa: E501
        """get_cloud_users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_users(cloud_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cloud_users_with_http_info(cloud_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_users_with_http_info(cloud_pk, **kwargs)  # noqa: E501
            return data

    def get_cloud_users_with_http_info(self, cloud_pk, **kwargs):  # noqa: E501
        """get_cloud_users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_users_with_http_info(cloud_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_cloud_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/user', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[User]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_clouds(self, **kwargs):  # noqa: E501
        """get_clouds  # noqa: E501

        Returns user's cloud only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_clouds(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Cloud]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_clouds_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_clouds_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_clouds_with_http_info(self, **kwargs):  # noqa: E501
        """get_clouds  # noqa: E501

        Returns user's cloud only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_clouds_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Cloud]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clouds" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Cloud]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cloud(self, id, cloud, **kwargs):  # noqa: E501
        """update_cloud  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud(id, cloud, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param Cloud cloud: (required)
        :return: Cloud
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cloud_with_http_info(id, cloud, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cloud_with_http_info(id, cloud, **kwargs)  # noqa: E501
            return data

    def update_cloud_with_http_info(self, id, cloud, **kwargs):  # noqa: E501
        """update_cloud  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_with_http_info(id, cloud, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param Cloud cloud: (required)
        :return: Cloud
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'cloud']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cloud" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_cloud`")  # noqa: E501
        # verify the required parameter 'cloud' is set
        if ('cloud' not in local_var_params or
                local_var_params['cloud'] is None):
            raise ValueError("Missing the required parameter `cloud` when calling `update_cloud`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud' in local_var_params:
            body_params = local_var_params['cloud']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cloud',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cloud_user(self, cloud_pk, id, invite_user, **kwargs):  # noqa: E501
        """update_cloud_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_user(cloud_pk, id, invite_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param InviteUser invite_user: (required)
        :return: InviteUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cloud_user_with_http_info(cloud_pk, id, invite_user, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cloud_user_with_http_info(cloud_pk, id, invite_user, **kwargs)  # noqa: E501
            return data

    def update_cloud_user_with_http_info(self, cloud_pk, id, invite_user, **kwargs):  # noqa: E501
        """update_cloud_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_user_with_http_info(cloud_pk, id, invite_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param InviteUser invite_user: (required)
        :return: InviteUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'invite_user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cloud_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_cloud_user`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_cloud_user`")  # noqa: E501
        # verify the required parameter 'invite_user' is set
        if ('invite_user' not in local_var_params or
                local_var_params['invite_user'] is None):
            raise ValueError("Missing the required parameter `invite_user` when calling `update_cloud_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invite_user' in local_var_params:
            body_params = local_var_params['invite_user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/user/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InviteUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
