# coding: utf-8

"""
    BIMData API

    BIMData API documentation  # noqa: E501

    OpenAPI spec version: v1
    Contact: contact@bimdata.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from bimdata_api_client.api_client import ApiClient


class ProjectApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_classification(self, cloud_pk, project_pk, classification, **kwargs):  # noqa: E501
        """create_classification  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors          If created classification already exists, it will not be duplicated and the previous one will be returned.     You also can add a 'classification' filter on this endpoint. By ex: /classification?name='untec'. The name is case sensitive       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_classification(cloud_pk, project_pk, classification, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param list[Classification] classification: (required)
        :return: list[Classification]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_classification_with_http_info(cloud_pk, project_pk, classification, **kwargs)  # noqa: E501
        else:
            (data) = self.create_classification_with_http_info(cloud_pk, project_pk, classification, **kwargs)  # noqa: E501
            return data

    def create_classification_with_http_info(self, cloud_pk, project_pk, classification, **kwargs):  # noqa: E501
        """create_classification  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors          If created classification already exists, it will not be duplicated and the previous one will be returned.     You also can add a 'classification' filter on this endpoint. By ex: /classification?name='untec'. The name is case sensitive       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_classification_with_http_info(cloud_pk, project_pk, classification, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param list[Classification] classification: (required)
        :return: list[Classification]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'project_pk', 'classification']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_classification" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_classification`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_classification`")  # noqa: E501
        # verify the required parameter 'classification' is set
        if ('classification' not in local_var_params or
                local_var_params['classification'] is None):
            raise ValueError("Missing the required parameter `classification` when calling `create_classification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'classification' in local_var_params:
            body_params = local_var_params['classification']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/classification', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Classification]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_document(self, cloud_pk, project_pk, name, **kwargs):  # noqa: E501
        """create_document  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_document(cloud_pk, project_pk, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param str name: (required)
        :param int id:
        :param int parent:
        :param int parent_id:
        :param int creator:
        :param int project:
        :param str file_name:
        :param str description:
        :param file file:
        :param str size:
        :param datetime created_at:
        :param datetime updated_at:
        :param str ifc_id:
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_document_with_http_info(cloud_pk, project_pk, name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_document_with_http_info(cloud_pk, project_pk, name, **kwargs)  # noqa: E501
            return data

    def create_document_with_http_info(self, cloud_pk, project_pk, name, **kwargs):  # noqa: E501
        """create_document  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_document_with_http_info(cloud_pk, project_pk, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param str name: (required)
        :param int id:
        :param int parent:
        :param int parent_id:
        :param int creator:
        :param int project:
        :param str file_name:
        :param str description:
        :param file file:
        :param str size:
        :param datetime created_at:
        :param datetime updated_at:
        :param str ifc_id:
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'project_pk', 'name', 'id', 'parent', 'parent_id', 'creator', 'project', 'file_name', 'description', 'file', 'size', 'created_at', 'updated_at', 'ifc_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_document" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_document`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_document`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in local_var_params or
                local_var_params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_document`")  # noqa: E501

        if ('name' in local_var_params and
                len(local_var_params['name']) > 512):
            raise ValueError("Invalid value for parameter `name` when calling `create_document`, length must be less than or equal to `512`")  # noqa: E501
        if ('name' in local_var_params and
                len(local_var_params['name']) < 1):
            raise ValueError("Invalid value for parameter `name` when calling `create_document`, length must be greater than or equal to `1`")  # noqa: E501
        if ('file_name' in local_var_params and
                len(local_var_params['file_name']) > 512):
            raise ValueError("Invalid value for parameter `file_name` when calling `create_document`, length must be less than or equal to `512`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'id' in local_var_params:
            form_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'parent' in local_var_params:
            form_params.append(('parent', local_var_params['parent']))  # noqa: E501
        if 'parent_id' in local_var_params:
            form_params.append(('parent_id', local_var_params['parent_id']))  # noqa: E501
        if 'creator' in local_var_params:
            form_params.append(('creator', local_var_params['creator']))  # noqa: E501
        if 'project' in local_var_params:
            form_params.append(('project', local_var_params['project']))  # noqa: E501
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'file_name' in local_var_params:
            form_params.append(('file_name', local_var_params['file_name']))  # noqa: E501
        if 'description' in local_var_params:
            form_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501
        if 'size' in local_var_params:
            form_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'created_at' in local_var_params:
            form_params.append(('created_at', local_var_params['created_at']))  # noqa: E501
        if 'updated_at' in local_var_params:
            form_params.append(('updated_at', local_var_params['updated_at']))  # noqa: E501
        if 'ifc_id' in local_var_params:
            form_params.append(('ifc_id', local_var_params['ifc_id']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/document', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Document',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_folder(self, cloud_pk, project_pk, folder, **kwargs):  # noqa: E501
        """create_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_folder(cloud_pk, project_pk, folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param Folder folder: (required)
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_folder_with_http_info(cloud_pk, project_pk, folder, **kwargs)  # noqa: E501
        else:
            (data) = self.create_folder_with_http_info(cloud_pk, project_pk, folder, **kwargs)  # noqa: E501
            return data

    def create_folder_with_http_info(self, cloud_pk, project_pk, folder, **kwargs):  # noqa: E501
        """create_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_folder_with_http_info(cloud_pk, project_pk, folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param Folder folder: (required)
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'project_pk', 'folder']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_folder`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_folder`")  # noqa: E501
        # verify the required parameter 'folder' is set
        if ('folder' not in local_var_params or
                local_var_params['folder'] is None):
            raise ValueError("Missing the required parameter `folder` when calling `create_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'folder' in local_var_params:
            body_params = local_var_params['folder']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/folder', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Folder',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_project(self, cloud_pk, project, **kwargs):  # noqa: E501
        """create_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project(cloud_pk, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param Project project: (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_project_with_http_info(cloud_pk, project, **kwargs)  # noqa: E501
        else:
            (data) = self.create_project_with_http_info(cloud_pk, project, **kwargs)  # noqa: E501
            return data

    def create_project_with_http_info(self, cloud_pk, project, **kwargs):  # noqa: E501
        """create_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_with_http_info(cloud_pk, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param Project project: (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_project`")  # noqa: E501
        # verify the required parameter 'project' is set
        if ('project' not in local_var_params or
                local_var_params['project'] is None):
            raise ValueError("Missing the required parameter `project` when calling `create_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'project' in local_var_params:
            body_params = local_var_params['project']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Project',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_project_user(self, cloud_pk, project_pk, invite_user, **kwargs):  # noqa: E501
        """create_project_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_user(cloud_pk, project_pk, invite_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param InviteUser invite_user: (required)
        :return: InviteUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_project_user_with_http_info(cloud_pk, project_pk, invite_user, **kwargs)  # noqa: E501
        else:
            (data) = self.create_project_user_with_http_info(cloud_pk, project_pk, invite_user, **kwargs)  # noqa: E501
            return data

    def create_project_user_with_http_info(self, cloud_pk, project_pk, invite_user, **kwargs):  # noqa: E501
        """create_project_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_user_with_http_info(cloud_pk, project_pk, invite_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param InviteUser invite_user: (required)
        :return: InviteUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'project_pk', 'invite_user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_project_user`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_project_user`")  # noqa: E501
        # verify the required parameter 'invite_user' is set
        if ('invite_user' not in local_var_params or
                local_var_params['invite_user'] is None):
            raise ValueError("Missing the required parameter `invite_user` when calling `create_project_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invite_user' in local_var_params:
            body_params = local_var_params['invite_user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/user', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InviteUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_classification(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_classification(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this classification. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_classification_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_classification_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_classification_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_classification_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this classification. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_classification" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_classification`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_classification`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_classification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/classification/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_document(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_document  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_document(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this document. (required)
        :param str project_pk: (required)
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_document_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_document_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_document_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_document  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_document_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this document. (required)
        :param str project_pk: (required)
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_document`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_document`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/document/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Document',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_folder(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_folder(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this folder. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_folder_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_folder_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_folder_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_folder_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this folder. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_folder`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_folder`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/folder/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_project(self, cloud_pk, id, **kwargs):  # noqa: E501
        """delete_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project(cloud_pk, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_project_with_http_info(cloud_pk, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_project_with_http_info(cloud_pk, id, **kwargs)  # noqa: E501
            return data

    def delete_project_with_http_info(self, cloud_pk, id, **kwargs):  # noqa: E501
        """delete_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_with_http_info(cloud_pk, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_project`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_project_user(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_project_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_user(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_project_user_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_project_user_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_project_user_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_project_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_user_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_project_user`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_project_user`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_project_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/user/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_classification(self, cloud_pk, id, project_pk, classification, **kwargs):  # noqa: E501
        """full_update_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_classification(cloud_pk, id, project_pk, classification, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this classification. (required)
        :param str project_pk: (required)
        :param Classification classification: (required)
        :return: Classification
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_classification_with_http_info(cloud_pk, id, project_pk, classification, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_classification_with_http_info(cloud_pk, id, project_pk, classification, **kwargs)  # noqa: E501
            return data

    def full_update_classification_with_http_info(self, cloud_pk, id, project_pk, classification, **kwargs):  # noqa: E501
        """full_update_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_classification_with_http_info(cloud_pk, id, project_pk, classification, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this classification. (required)
        :param str project_pk: (required)
        :param Classification classification: (required)
        :return: Classification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk', 'classification']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_classification" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_classification`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_classification`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_classification`")  # noqa: E501
        # verify the required parameter 'classification' is set
        if ('classification' not in local_var_params or
                local_var_params['classification'] is None):
            raise ValueError("Missing the required parameter `classification` when calling `full_update_classification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'classification' in local_var_params:
            body_params = local_var_params['classification']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/classification/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Classification',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_document(self, cloud_pk, id, project_pk, name, **kwargs):  # noqa: E501
        """full_update_document  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_document(cloud_pk, id, project_pk, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this document. (required)
        :param str project_pk: (required)
        :param str name: (required)
        :param int id:
        :param int parent:
        :param int parent_id:
        :param int creator:
        :param int project:
        :param str file_name:
        :param str description:
        :param file file:
        :param str size:
        :param datetime created_at:
        :param datetime updated_at:
        :param str ifc_id:
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_document_with_http_info(cloud_pk, id, project_pk, name, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_document_with_http_info(cloud_pk, id, project_pk, name, **kwargs)  # noqa: E501
            return data

    def full_update_document_with_http_info(self, cloud_pk, id, project_pk, name, **kwargs):  # noqa: E501
        """full_update_document  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_document_with_http_info(cloud_pk, id, project_pk, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this document. (required)
        :param str project_pk: (required)
        :param str name: (required)
        :param int id:
        :param int parent:
        :param int parent_id:
        :param int creator:
        :param int project:
        :param str file_name:
        :param str description:
        :param file file:
        :param str size:
        :param datetime created_at:
        :param datetime updated_at:
        :param str ifc_id:
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk', 'name', 'id', 'parent', 'parent_id', 'creator', 'project', 'file_name', 'description', 'file', 'size', 'created_at', 'updated_at', 'ifc_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_document" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_document`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_document`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_document`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in local_var_params or
                local_var_params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `full_update_document`")  # noqa: E501

        if ('name' in local_var_params and
                len(local_var_params['name']) > 512):
            raise ValueError("Invalid value for parameter `name` when calling `full_update_document`, length must be less than or equal to `512`")  # noqa: E501
        if ('name' in local_var_params and
                len(local_var_params['name']) < 1):
            raise ValueError("Invalid value for parameter `name` when calling `full_update_document`, length must be greater than or equal to `1`")  # noqa: E501
        if ('file_name' in local_var_params and
                len(local_var_params['file_name']) > 512):
            raise ValueError("Invalid value for parameter `file_name` when calling `full_update_document`, length must be less than or equal to `512`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'id' in local_var_params:
            form_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'parent' in local_var_params:
            form_params.append(('parent', local_var_params['parent']))  # noqa: E501
        if 'parent_id' in local_var_params:
            form_params.append(('parent_id', local_var_params['parent_id']))  # noqa: E501
        if 'creator' in local_var_params:
            form_params.append(('creator', local_var_params['creator']))  # noqa: E501
        if 'project' in local_var_params:
            form_params.append(('project', local_var_params['project']))  # noqa: E501
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'file_name' in local_var_params:
            form_params.append(('file_name', local_var_params['file_name']))  # noqa: E501
        if 'description' in local_var_params:
            form_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501
        if 'size' in local_var_params:
            form_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'created_at' in local_var_params:
            form_params.append(('created_at', local_var_params['created_at']))  # noqa: E501
        if 'updated_at' in local_var_params:
            form_params.append(('updated_at', local_var_params['updated_at']))  # noqa: E501
        if 'ifc_id' in local_var_params:
            form_params.append(('ifc_id', local_var_params['ifc_id']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/document/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Document',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_folder(self, cloud_pk, id, project_pk, folder, **kwargs):  # noqa: E501
        """full_update_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_folder(cloud_pk, id, project_pk, folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this folder. (required)
        :param str project_pk: (required)
        :param Folder folder: (required)
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_folder_with_http_info(cloud_pk, id, project_pk, folder, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_folder_with_http_info(cloud_pk, id, project_pk, folder, **kwargs)  # noqa: E501
            return data

    def full_update_folder_with_http_info(self, cloud_pk, id, project_pk, folder, **kwargs):  # noqa: E501
        """full_update_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_folder_with_http_info(cloud_pk, id, project_pk, folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this folder. (required)
        :param str project_pk: (required)
        :param Folder folder: (required)
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk', 'folder']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_folder`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_folder`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_folder`")  # noqa: E501
        # verify the required parameter 'folder' is set
        if ('folder' not in local_var_params or
                local_var_params['folder'] is None):
            raise ValueError("Missing the required parameter `folder` when calling `full_update_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'folder' in local_var_params:
            body_params = local_var_params['folder']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/folder/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Folder',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_project(self, cloud_pk, id, project, **kwargs):  # noqa: E501
        """full_update_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_project(cloud_pk, id, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param Project project: (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_project_with_http_info(cloud_pk, id, project, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_project_with_http_info(cloud_pk, id, project, **kwargs)  # noqa: E501
            return data

    def full_update_project_with_http_info(self, cloud_pk, id, project, **kwargs):  # noqa: E501
        """full_update_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_project_with_http_info(cloud_pk, id, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param Project project: (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_project`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_project`")  # noqa: E501
        # verify the required parameter 'project' is set
        if ('project' not in local_var_params or
                local_var_params['project'] is None):
            raise ValueError("Missing the required parameter `project` when calling `full_update_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'project' in local_var_params:
            body_params = local_var_params['project']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Project',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_project_user(self, cloud_pk, id, project_pk, invite_user, **kwargs):  # noqa: E501
        """full_update_project_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_project_user(cloud_pk, id, project_pk, invite_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str project_pk: (required)
        :param InviteUser invite_user: (required)
        :return: InviteUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_project_user_with_http_info(cloud_pk, id, project_pk, invite_user, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_project_user_with_http_info(cloud_pk, id, project_pk, invite_user, **kwargs)  # noqa: E501
            return data

    def full_update_project_user_with_http_info(self, cloud_pk, id, project_pk, invite_user, **kwargs):  # noqa: E501
        """full_update_project_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_project_user_with_http_info(cloud_pk, id, project_pk, invite_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str project_pk: (required)
        :param InviteUser invite_user: (required)
        :return: InviteUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk', 'invite_user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_project_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_project_user`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_project_user`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_project_user`")  # noqa: E501
        # verify the required parameter 'invite_user' is set
        if ('invite_user' not in local_var_params or
                local_var_params['invite_user'] is None):
            raise ValueError("Missing the required parameter `invite_user` when calling `full_update_project_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invite_user' in local_var_params:
            body_params = local_var_params['invite_user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/user/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InviteUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_classification(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_classification(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this classification. (required)
        :param str project_pk: (required)
        :return: Classification
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_classification_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_classification_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def get_classification_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_classification_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this classification. (required)
        :param str project_pk: (required)
        :return: Classification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_classification" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_classification`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_classification`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_classification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/classification/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Classification',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_classifications(self, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_classifications  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_classifications(cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :return: list[Classification]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_classifications_with_http_info(cloud_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_classifications_with_http_info(cloud_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_classifications_with_http_info(self, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_classifications  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_classifications_with_http_info(cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :return: list[Classification]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_classifications" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_classifications`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_classifications`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/classification', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Classification]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_document(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_document  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_document(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this document. (required)
        :param str project_pk: (required)
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_document_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_document_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def get_document_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_document  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_document_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this document. (required)
        :param str project_pk: (required)
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_document`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_document`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/document/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Document',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_documents(self, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_documents  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents(cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_documents_with_http_info(cloud_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_documents_with_http_info(cloud_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_documents_with_http_info(self, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_documents  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_with_http_info(cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_documents`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_documents`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/document', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Document',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_folder(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_folder(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this folder. (required)
        :param str project_pk: (required)
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_folder_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_folder_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def get_folder_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_folder_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this folder. (required)
        :param str project_pk: (required)
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_folder`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_folder`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/folder/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Folder',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_folders(self, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_folders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_folders(cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :return: list[Folder]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_folders_with_http_info(cloud_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_folders_with_http_info(cloud_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_folders_with_http_info(self, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_folders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_folders_with_http_info(cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :return: list[Folder]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_folders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_folders`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_folders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/folder', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Folder]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project(self, cloud_pk, id, **kwargs):  # noqa: E501
        """get_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project(cloud_pk, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_with_http_info(cloud_pk, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_with_http_info(cloud_pk, id, **kwargs)  # noqa: E501
            return data

    def get_project_with_http_info(self, cloud_pk, id, **kwargs):  # noqa: E501
        """get_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_with_http_info(cloud_pk, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_project`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Project',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_tree(self, cloud_pk, id, **kwargs):  # noqa: E501
        """get_project_tree  # noqa: E501

        Returns the document tree from root folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_tree(cloud_pk, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_tree_with_http_info(cloud_pk, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_tree_with_http_info(cloud_pk, id, **kwargs)  # noqa: E501
            return data

    def get_project_tree_with_http_info(self, cloud_pk, id, **kwargs):  # noqa: E501
        """get_project_tree  # noqa: E501

        Returns the document tree from root folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_tree_with_http_info(cloud_pk, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_tree" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_project_tree`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_project_tree`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{id}/tree', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Folder',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_user(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_project_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_user(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str project_pk: (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_user_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_user_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def get_project_user_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_project_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_user_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str project_pk: (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_project_user`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_project_user`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_project_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/user/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='User',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_users(self, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_project_users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_users(cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_users_with_http_info(cloud_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_users_with_http_info(cloud_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_project_users_with_http_info(self, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_project_users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_users_with_http_info(cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_project_users`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_project_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/user', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[User]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_projects(self, cloud_pk, **kwargs):  # noqa: E501
        """get_projects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_projects(cloud_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :return: list[Project]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_projects_with_http_info(cloud_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_projects_with_http_info(cloud_pk, **kwargs)  # noqa: E501
            return data

    def get_projects_with_http_info(self, cloud_pk, **kwargs):  # noqa: E501
        """get_projects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_projects_with_http_info(cloud_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :return: list[Project]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_projects" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_projects`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Project]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_classification(self, cloud_pk, id, project_pk, classification, **kwargs):  # noqa: E501
        """update_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_classification(cloud_pk, id, project_pk, classification, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this classification. (required)
        :param str project_pk: (required)
        :param Classification classification: (required)
        :return: Classification
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_classification_with_http_info(cloud_pk, id, project_pk, classification, **kwargs)  # noqa: E501
        else:
            (data) = self.update_classification_with_http_info(cloud_pk, id, project_pk, classification, **kwargs)  # noqa: E501
            return data

    def update_classification_with_http_info(self, cloud_pk, id, project_pk, classification, **kwargs):  # noqa: E501
        """update_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_classification_with_http_info(cloud_pk, id, project_pk, classification, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this classification. (required)
        :param str project_pk: (required)
        :param Classification classification: (required)
        :return: Classification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk', 'classification']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_classification" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_classification`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_classification`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_classification`")  # noqa: E501
        # verify the required parameter 'classification' is set
        if ('classification' not in local_var_params or
                local_var_params['classification'] is None):
            raise ValueError("Missing the required parameter `classification` when calling `update_classification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'classification' in local_var_params:
            body_params = local_var_params['classification']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/classification/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Classification',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_document(self, cloud_pk, id, project_pk, document, **kwargs):  # noqa: E501
        """update_document  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_document(cloud_pk, id, project_pk, document, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this document. (required)
        :param str project_pk: (required)
        :param Document document: (required)
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_document_with_http_info(cloud_pk, id, project_pk, document, **kwargs)  # noqa: E501
        else:
            (data) = self.update_document_with_http_info(cloud_pk, id, project_pk, document, **kwargs)  # noqa: E501
            return data

    def update_document_with_http_info(self, cloud_pk, id, project_pk, document, **kwargs):  # noqa: E501
        """update_document  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_document_with_http_info(cloud_pk, id, project_pk, document, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this document. (required)
        :param str project_pk: (required)
        :param Document document: (required)
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk', 'document']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_document" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_document`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_document`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_document`")  # noqa: E501
        # verify the required parameter 'document' is set
        if ('document' not in local_var_params or
                local_var_params['document'] is None):
            raise ValueError("Missing the required parameter `document` when calling `update_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document' in local_var_params:
            body_params = local_var_params['document']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/document/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Document',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_folder(self, cloud_pk, id, project_pk, folder, **kwargs):  # noqa: E501
        """update_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_folder(cloud_pk, id, project_pk, folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this folder. (required)
        :param str project_pk: (required)
        :param Folder folder: (required)
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_folder_with_http_info(cloud_pk, id, project_pk, folder, **kwargs)  # noqa: E501
        else:
            (data) = self.update_folder_with_http_info(cloud_pk, id, project_pk, folder, **kwargs)  # noqa: E501
            return data

    def update_folder_with_http_info(self, cloud_pk, id, project_pk, folder, **kwargs):  # noqa: E501
        """update_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_folder_with_http_info(cloud_pk, id, project_pk, folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this folder. (required)
        :param str project_pk: (required)
        :param Folder folder: (required)
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk', 'folder']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_folder`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_folder`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_folder`")  # noqa: E501
        # verify the required parameter 'folder' is set
        if ('folder' not in local_var_params or
                local_var_params['folder'] is None):
            raise ValueError("Missing the required parameter `folder` when calling `update_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'folder' in local_var_params:
            body_params = local_var_params['folder']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/folder/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Folder',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_project(self, cloud_pk, id, project, **kwargs):  # noqa: E501
        """update_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project(cloud_pk, id, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param Project project: (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_project_with_http_info(cloud_pk, id, project, **kwargs)  # noqa: E501
        else:
            (data) = self.update_project_with_http_info(cloud_pk, id, project, **kwargs)  # noqa: E501
            return data

    def update_project_with_http_info(self, cloud_pk, id, project, **kwargs):  # noqa: E501
        """update_project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_with_http_info(cloud_pk, id, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param Project project: (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_project`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_project`")  # noqa: E501
        # verify the required parameter 'project' is set
        if ('project' not in local_var_params or
                local_var_params['project'] is None):
            raise ValueError("Missing the required parameter `project` when calling `update_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'project' in local_var_params:
            body_params = local_var_params['project']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Project',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_project_user(self, cloud_pk, id, project_pk, invite_user, **kwargs):  # noqa: E501
        """update_project_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_user(cloud_pk, id, project_pk, invite_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str project_pk: (required)
        :param InviteUser invite_user: (required)
        :return: InviteUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_project_user_with_http_info(cloud_pk, id, project_pk, invite_user, **kwargs)  # noqa: E501
        else:
            (data) = self.update_project_user_with_http_info(cloud_pk, id, project_pk, invite_user, **kwargs)  # noqa: E501
            return data

    def update_project_user_with_http_info(self, cloud_pk, id, project_pk, invite_user, **kwargs):  # noqa: E501
        """update_project_user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_user_with_http_info(cloud_pk, id, project_pk, invite_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str project_pk: (required)
        :param InviteUser invite_user: (required)
        :return: InviteUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk', 'invite_user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_project_user`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_project_user`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_project_user`")  # noqa: E501
        # verify the required parameter 'invite_user' is set
        if ('invite_user' not in local_var_params or
                local_var_params['invite_user'] is None):
            raise ValueError("Missing the required parameter `invite_user` when calling `update_project_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invite_user' in local_var_params:
            body_params = local_var_params['invite_user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/user/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InviteUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
