"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasCondition = exports.findConditions = void 0;
const section_1 = require("./section");
function findConditions(template, logicalId, props = {}) {
    const section = template.Conditions ?? {};
    const result = (0, section_1.matchSection)((0, section_1.filterLogicalId)(section, logicalId), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findConditions = findConditions;
function hasCondition(template, logicalId, props) {
    const section = template.Conditions ?? {};
    const result = (0, section_1.matchSection)((0, section_1.filterLogicalId)(section, logicalId), props);
    if (result.match) {
        return;
    }
    return (0, section_1.formatSectionMatchFailure)(`conditions with logicalId ${logicalId}`, result);
}
exports.hasCondition = hasCondition;
//# sourceMappingURL=data:application/json;base64,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