"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasParameter = exports.findParameters = void 0;
const section_1 = require("./section");
function findParameters(template, logicalId, props = {}) {
    const section = template.Parameters ?? {};
    const result = (0, section_1.matchSection)((0, section_1.filterLogicalId)(section, logicalId), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findParameters = findParameters;
function hasParameter(template, logicalId, props) {
    const section = template.Parameters ?? {};
    const result = (0, section_1.matchSection)((0, section_1.filterLogicalId)(section, logicalId), props);
    if (result.match) {
        return;
    }
    return (0, section_1.formatSectionMatchFailure)(`parameters with logicalId '${logicalId}'`, result);
}
exports.hasParameter = hasParameter;
//# sourceMappingURL=data:application/json;base64,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