"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sortKeyComparator = void 0;
/**
 * Make a sorting comparator that will sort by a given sort key
 */
function sortKeyComparator(keyFn) {
    return (a, b) => {
        const ak = keyFn(a);
        const bk = keyFn(b);
        for (let i = 0; i < ak.length && i < bk.length; i++) {
            const av = ak[i];
            const bv = bk[i];
            let diff = 0;
            if (typeof av === 'number' && typeof bv === 'number') {
                diff = av - bv;
            }
            else if (typeof av === 'string' && typeof bv === 'string') {
                diff = av.localeCompare(bv);
            }
            if (diff !== 0) {
                return diff;
            }
        }
        return (bk.length - ak.length);
    };
}
exports.sortKeyComparator = sortKeyComparator;
//# sourceMappingURL=data:application/json;base64,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