"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SparseMatrix = void 0;
class SparseMatrix {
    constructor() {
        this.matrix = new Map();
    }
    get(row, col) {
        return this.matrix.get(row)?.get(col);
    }
    row(row) {
        return Array.from(this.matrix.get(row)?.entries() ?? []);
    }
    set(row, col, value) {
        let r = this.matrix.get(row);
        if (!r) {
            r = new Map();
            this.matrix.set(row, r);
        }
        r.set(col, value);
    }
}
exports.SparseMatrix = SparseMatrix;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3BhcnNlLW1hdHJpeC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNwYXJzZS1tYXRyaXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsTUFBYSxZQUFZO0lBQXpCO1FBQ21CLFdBQU0sR0FBRyxJQUFJLEdBQUcsRUFBMEIsQ0FBQztJQWtCOUQsQ0FBQztJQWhCUSxHQUFHLENBQUMsR0FBVyxFQUFFLEdBQVc7UUFDakMsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsRUFBRSxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7S0FDdkM7SUFFTSxHQUFHLENBQUMsR0FBVztRQUNwQixPQUFPLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7S0FDMUQ7SUFFTSxHQUFHLENBQUMsR0FBVyxFQUFFLEdBQVcsRUFBRSxLQUFRO1FBQzNDLElBQUksQ0FBQyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQzdCLElBQUksQ0FBQyxDQUFDLEVBQUU7WUFDTixDQUFDLEdBQUcsSUFBSSxHQUFHLEVBQUUsQ0FBQztZQUNkLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUMsQ0FBQztTQUN6QjtRQUNELENBQUMsQ0FBQyxHQUFHLENBQUMsR0FBRyxFQUFFLEtBQUssQ0FBQyxDQUFDO0tBQ25CO0NBQ0Y7QUFuQkQsb0NBbUJDIiwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGNsYXNzIFNwYXJzZU1hdHJpeDxBPiB7XG4gIHByaXZhdGUgcmVhZG9ubHkgbWF0cml4ID0gbmV3IE1hcDxudW1iZXIsIE1hcDxudW1iZXIsIEE+PigpO1xuXG4gIHB1YmxpYyBnZXQocm93OiBudW1iZXIsIGNvbDogbnVtYmVyKTogQSB8IHVuZGVmaW5lZCB7XG4gICAgcmV0dXJuIHRoaXMubWF0cml4LmdldChyb3cpPy5nZXQoY29sKTtcbiAgfVxuXG4gIHB1YmxpYyByb3cocm93OiBudW1iZXIpOiBBcnJheTxbbnVtYmVyLCBBXT4ge1xuICAgIHJldHVybiBBcnJheS5mcm9tKHRoaXMubWF0cml4LmdldChyb3cpPy5lbnRyaWVzKCkgPz8gW10pO1xuICB9XG5cbiAgcHVibGljIHNldChyb3c6IG51bWJlciwgY29sOiBudW1iZXIsIHZhbHVlOiBBKTogdm9pZCB7XG4gICAgbGV0IHIgPSB0aGlzLm1hdHJpeC5nZXQocm93KTtcbiAgICBpZiAoIXIpIHtcbiAgICAgIHIgPSBuZXcgTWFwKCk7XG4gICAgICB0aGlzLm1hdHJpeC5zZXQocm93LCByKTtcbiAgICB9XG4gICAgci5zZXQoY29sLCB2YWx1ZSk7XG4gIH1cbn0iXX0=