"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessLogFormat = exports.AccessLogField = exports.LogGroupLogDestination = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use CloudWatch Logs as a custom access log destination for API Gateway.
 */
class LogGroupLogDestination {
    constructor(logGroup) {
        this.logGroup = logGroup;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_logs_ILogGroup(logGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LogGroupLogDestination);
            }
            throw error;
        }
    }
    /**
     * Binds this destination to the CloudWatch Logs.
     */
    bind(_stage) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_IStage(_stage);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            destinationArn: this.logGroup.logGroupArn,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
LogGroupLogDestination[_a] = { fqn: "aws-cdk-lib.aws_apigateway.LogGroupLogDestination", version: "2.74.0" };
exports.LogGroupLogDestination = LogGroupLogDestination;
/**
 * $context variables that can be used to customize access log pattern.
 */
class AccessLogField {
    /**
     * The API callers AWS account ID.
     * @deprecated Use `contextCallerAccountId` or `contextOwnerAccountId` instead
     */
    static contextAccountId() {
        try {
            jsiiDeprecationWarnings.print("aws-cdk-lib.aws_apigateway.AccessLogField#contextAccountId", "Use `contextCallerAccountId` or `contextOwnerAccountId` instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.contextAccountId);
            }
            throw error;
        }
        return '$context.identity.accountId';
    }
    /**
     * The API callers AWS account ID.
     */
    static contextCallerAccountId() {
        return '$context.identity.accountId';
    }
    /**
     * The API owner's AWS account ID.
     */
    static contextOwnerAccountId() {
        return '$context.accountId';
    }
    /**
     * The identifier API Gateway assigns to your API.
     */
    static contextApiId() {
        return '$context.apiId';
    }
    /**
     * A property of the claims returned from the Amazon Cognito user pool after the method caller is successfully authenticated.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html
     *
     * @param property A property key of the claims.
     */
    static contextAuthorizerClaims(property) {
        return `$context.authorizer.claims.${property}`;
    }
    /**
     * The principal user identification associated with the token sent by the client and returned
     * from an API Gateway Lambda authorizer (formerly known as a custom authorizer).
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html
     */
    static contextAuthorizerPrincipalId() {
        return '$context.authorizer.principalId';
    }
    /**
     * The stringified value of the specified key-value pair of the `context` map returned from an API Gateway Lambda authorizer function.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html
     * @param property key of the context map.
     */
    static contextAuthorizer(property) {
        return `$context.authorizer.${property}`;
    }
    /**
     * The AWS endpoint's request ID.
     */
    static contextAwsEndpointRequestId() {
        return '$context.awsEndpointRequestId';
    }
    /**
     * The full domain name used to invoke the API. This should be the same as the incoming `Host` header.
     */
    static contextDomainName() {
        return '$context.domainName';
    }
    /**
     * The first label of the `$context.domainName`. This is often used as a caller/customer identifier.
     */
    static contextDomainPrefix() {
        return '$context.domainPrefix';
    }
    /**
     * A string containing an API Gateway error message.
     */
    static contextErrorMessage() {
        return '$context.error.message';
    }
    /**
     * The quoted value of $context.error.message, namely "$context.error.message".
     */
    static contextErrorMessageString() {
        return '$context.error.messageString';
    }
    /**
     * A type of GatewayResponse. This variable can only be used for simple variable substitution in a GatewayResponse body-mapping template,
     * which is not processed by the Velocity Template Language engine, and in access logging.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-logging.html
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html
     */
    static contextErrorResponseType() {
        return '$context.error.responseType';
    }
    /**
     * A string containing a detailed validation error message.
     */
    static contextErrorValidationErrorString() {
        return '$context.error.validationErrorString';
    }
    /**
     * The extended ID that API Gateway assigns to the API request, which contains more useful information for debugging/troubleshooting.
     */
    static contextExtendedRequestId() {
        return '$context.extendedRequestId';
    }
    /**
     * The HTTP method used. Valid values include: `DELETE`, `GET`, `HEAD`, `OPTIONS`, `PATCH`, `POST`, and `PUT`.
     */
    static contextHttpMethod() {
        return '$context.httpMethod';
    }
    /**
     * The AWS account ID associated with the request.
     */
    static contextIdentityAccountId() {
        return '$context.identity.accountId';
    }
    /**
     * For API methods that require an API key, this variable is the API key associated with the method request.
     * For methods that don't require an API key, this variable is
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html
     */
    static contextIdentityApiKey() {
        return '$context.identity.apiKey';
    }
    /**
     * The API key ID associated with an API request that requires an API key.
     */
    static contextIdentityApiKeyId() {
        return '$context.identity.apiKeyId';
    }
    /**
     * The principal identifier of the caller making the request.
     */
    static contextIdentityCaller() {
        return '$context.identity.caller';
    }
    /**
     * The Amazon Cognito authentication provider used by the caller making the request.
     * Available only if the request was signed with Amazon Cognito credentials.
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html
     */
    static contextIdentityCognitoAuthenticationProvider() {
        return '$context.identity.cognitoAuthenticationProvider';
    }
    /**
     * The Amazon Cognito authentication type of the caller making the request.
     * Available only if the request was signed with Amazon Cognito credentials.
     */
    static contextIdentityCognitoAuthenticationType() {
        return '$context.identity.cognitoAuthenticationType';
    }
    /**
     * The Amazon Cognito identity ID of the caller making the request. Available only if the request was signed with Amazon Cognito credentials.
     */
    static contextIdentityCognitoIdentityId() {
        return '$context.identity.cognitoIdentityId';
    }
    /**
     * The Amazon Cognito identity pool ID of the caller making the request.
     * Available only if the request was signed with Amazon Cognito credentials.
     */
    static contextIdentityCognitoIdentityPoolId() {
        return '$context.identity.cognitoIdentityPoolId';
    }
    /**
     * The AWS organization ID.
     */
    static contextIdentityPrincipalOrgId() {
        return '$context.identity.principalOrgId';
    }
    /**
     * The source IP address of the TCP connection making the request to API Gateway.
     * Warning: You should not trust this value if there is any chance that the `X-Forwarded-For` header could be forged.
     */
    static contextIdentitySourceIp() {
        return '$context.identity.sourceIp';
    }
    /**
     * The PEM-encoded client certificate that the client presented during mutual TLS authentication.
     * Present when a client accesses an API by using a custom domain name that has mutual TLS enabled.
     * Present only in access logs if mutual TLS authentication fails.
     */
    static contextIdentityClientCertPem() {
        return '$context.identity.clientCert.clientCertPem';
    }
    /**
     * The distinguished name of the subject of the certificate that a client presents.
     * Present when a client accesses an API by using a custom domain name that has mutual TLS enabled.
     * Present only in access logs if mutual TLS authentication fails.
     */
    static contextIdentityClientCertSubjectDN() {
        return '$context.identity.clientCert.subjectDN';
    }
    /**
     * The distinguished name of the issuer of the certificate that a client presents.
     * Present when a client accesses an API by using a custom domain name that has mutual TLS enabled.
     * Present only in access logs if mutual TLS authentication fails.
     */
    static contextIdentityClientCertIssunerDN() {
        return '$context.identity.clientCert.issuerDN';
    }
    /**
     * The serial number of the certificate.
     * Present when a client accesses an API by using a custom domain name that has mutual TLS enabled.
     * Present only in access logs if mutual TLS authentication fails.
     */
    static contextIdentityClientCertSerialNumber() {
        return '$context.identity.clientCert.serialNumber';
    }
    /**
     * The date before which the certificate is invalid.
     * Present when a client accesses an API by using a custom domain name that has mutual TLS enabled.
     * Present only in access logs if mutual TLS authentication fails.
     */
    static contextIdentityClientCertValidityNotBefore() {
        return '$context.identity.clientCert.validity.notBefore';
    }
    /**
     * The date after which the certificate is invalid.
     * Present when a client accesses an API by using a custom domain name that has mutual TLS enabled.
     * Present only in access logs if mutual TLS authentication fails.
     */
    static contextIdentityClientCertValidityNotAfter() {
        return '$context.identity.clientCert.validity.notAfter';
    }
    /**
     * The principal identifier of the user making the request. Used in Lambda authorizers.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html
     */
    static contextIdentityUser() {
        return '$context.identity.user';
    }
    /**
     * The User-Agent header of the API caller.
     */
    static contextIdentityUserAgent() {
        return '$context.identity.userAgent';
    }
    /**
     * The Amazon Resource Name (ARN) of the effective user identified after authentication.
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html
     */
    static contextIdentityUserArn() {
        return '$context.identity.userArn';
    }
    /**
     * The request path.
     * For example, for a non-proxy request URL of https://{rest-api-id.execute-api.{region}.amazonaws.com/{stage}/root/child,
     * this value is /{stage}/root/child.
     */
    static contextPath() {
        return '$context.path';
    }
    /**
     * The request protocol, for example, HTTP/1.1.
     */
    static contextProtocol() {
        return '$context.protocol';
    }
    /**
     * The ID that API Gateway assigns to the API request.
     */
    static contextRequestId() {
        return '$context.requestId';
    }
    /**
     * The request header override.
     * If this parameter is defined, it contains the headers to be used instead of the HTTP Headers that are defined in the Integration Request pane.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     *
     * @param headerName
     */
    static contextRequestOverrideHeader(headerName) {
        return `$context.requestOverride.header.${headerName}`;
    }
    /**
     * The request path override. If this parameter is defined,
     * it contains the request path to be used instead of the URL Path Parameters that are defined in the Integration Request pane.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     *
     * @param pathName
     */
    static contextRequestOverridePath(pathName) {
        return `$context.requestOverride.path.${pathName}`;
    }
    /**
     * The request query string override.
     * If this parameter is defined, it contains the request query strings to be used instead
     * of the URL Query String Parameters that are defined in the Integration Request pane.
     *
     * @param querystringName
     */
    static contextRequestOverrideQuerystring(querystringName) {
        return `$context.requestOverride.querystring.${querystringName}`;
    }
    /**
     * The response header override.
     * If this parameter is defined, it contains the header to be returned instead of the Response header
     * that is defined as the Default mapping in the Integration Response pane.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     *
     * @param headerName
     */
    static contextResponseOverrideHeader(headerName) {
        return `$context.responseOverride.header.${headerName}`;
    }
    /**
     * The response status code override.
     * If this parameter is defined, it contains the status code to be returned instead of the Method response status
     * that is defined as the Default mapping in the Integration Response pane.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     */
    static contextResponseOverrideStatus() {
        return '$context.responseOverride.status';
    }
    /**
     * The CLF-formatted request time (dd/MMM/yyyy:HH:mm:ss +-hhmm).
     */
    static contextRequestTime() {
        return '$context.requestTime';
    }
    /**
     * The Epoch-formatted request time.
     */
    static contextRequestTimeEpoch() {
        return '$context.requestTimeEpoch';
    }
    /**
     * The identifier that API Gateway assigns to your resource.
     */
    static contextResourceId() {
        return '$context.resourceId';
    }
    /**
     * The path to your resource.
     * For example, for the non-proxy request URI of `https://{rest-api-id.execute-api.{region}.amazonaws.com/{stage}/root/child`,
     * The $context.resourcePath value is `/root/child`.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-api-step-by-step.html
     */
    static contextResourcePath() {
        return '$context.resourcePath';
    }
    /**
     * The deployment stage of the API request (for example, `Beta` or `Prod`).
     */
    static contextStage() {
        return '$context.stage';
    }
    /**
     * The response received from AWS WAF: `WAF_ALLOW` or `WAF_BLOCK`. Will not be set if the stage is not associated with a web ACL.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html
     */
    static contextWafResponseCode() {
        return '$context.wafResponseCode';
    }
    /**
     * The complete ARN of the web ACL that is used to decide whether to allow or block the request.
     * Will not be set if the stage is not associated with a web ACL.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html
     */
    static contextWebaclArn() {
        return '$context.webaclArn';
    }
    /**
     * The trace ID for the X-Ray trace.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-enabling-xray.html
     */
    static contextXrayTraceId() {
        return '$context.xrayTraceId';
    }
    /**
     * The authorizer latency in ms.
     */
    static contextAuthorizerIntegrationLatency() {
        return '$context.authorizer.integrationLatency';
    }
    /**
     * The integration latency in ms.
     */
    static contextIntegrationLatency() {
        return '$context.integrationLatency';
    }
    /**
     * For Lambda proxy integration, this parameter represents the status code returned from AWS Lambda,
     * not from the backend Lambda function.
     */
    static contextIntegrationStatus() {
        return '$context.integrationStatus';
    }
    /**
     * The response latency in ms.
     */
    static contextResponseLatency() {
        return '$context.responseLatency';
    }
    /**
     * The response payload length.
     */
    static contextResponseLength() {
        return '$context.responseLength';
    }
    /**
     * The method response status.
     */
    static contextStatus() {
        return '$context.status';
    }
    /**
     * The authorization error message.
     */
    static contextAuthorizeError() {
        return '$context.authorize.error';
    }
    /**
     * The authorization latency in ms.
     */
    static contextAuthorizeLatency() {
        return '$context.authorize.latency';
    }
    /**
     * The status code returned from an authorization attempt.
     */
    static contextAuthorizeStatus() {
        return '$context.authorize.status';
    }
    /**
     * The error message returned from an authorizer.
     */
    static contextAuthorizerError() {
        return '$context.authorizer.error';
    }
    /**
     * The status code returned from a Lambda authorizer.
     */
    static contextAuthorizerIntegrationStatus() {
        return '$context.authorizer.integrationStatus';
    }
    /**
     * The authorizer latency in ms.
     */
    static contextAuthorizerLatency() {
        return '$context.authorizer.latency';
    }
    /**
     * The AWS endpoint's request ID.
     */
    static contextAuthorizerRequestId() {
        return '$context.authorizer.requestId';
    }
    /**
     * The status code returned from an authorizer.
     */
    static contextAuthorizerStatus() {
        return '$context.authorizer.status';
    }
    /**
     * The error message returned from an authentication attempt.
     */
    static contextAuthenticateError() {
        return '$context.authenticate.error';
    }
    /**
     * The authentication latency in ms.
     */
    static contextAuthenticateLatency() {
        return '$context.authenticate.latency';
    }
    /**
     * The status code returned from an authentication attempt.
     */
    static contextAuthenticateStatus() {
        return '$context.authenticate.status';
    }
    /**
     * The path for an API mapping that an incoming request matched.
     * Applicable when a client uses a custom domain name to access an API. For example if a client sends a request to
     * https://api.example.com/v1/orders/1234, and the request matches the API mapping with the path v1/orders, the value is v1/orders.
     * @see https://docs.aws.amazon.com/en_jp/apigateway/latest/developerguide/rest-api-mappings.html
     */
    static contextCustomDomainBasePathMatched() {
        return '$context.customDomain.basePathMatched';
    }
    /**
     * A string that contains an integration error message.
     */
    static contextIntegrationErrorMessage() {
        return '$context.integrationErrorMessage';
    }
    /**
     * The error message returned from AWS WAF.
     */
    static contextWafError() {
        return '$context.waf.error';
    }
    /**
     * The AWS WAF latency in ms.
     */
    static contextWafLatency() {
        return '$context.waf.latency';
    }
    /**
     * The status code returned from AWS WAF.
     */
    static contextWafStatus() {
        return '$context.waf.status';
    }
}
_b = JSII_RTTI_SYMBOL_1;
AccessLogField[_b] = { fqn: "aws-cdk-lib.aws_apigateway.AccessLogField", version: "2.74.0" };
exports.AccessLogField = AccessLogField;
/**
 * factory methods for access log format.
 */
class AccessLogFormat {
    /**
     * Custom log format.
     * You can create any log format string. You can easily get the $ context variable by using the methods of AccessLogField.
     * @param format
     * @example
     *
     *  apigateway.AccessLogFormat.custom(JSON.stringify({
     *      requestId: apigateway.AccessLogField.contextRequestId(),
     *      sourceIp: apigateway.AccessLogField.contextIdentitySourceIp(),
     *      method: apigateway.AccessLogField.contextHttpMethod(),
     *      userContext: {
     *        sub: apigateway.AccessLogField.contextAuthorizerClaims('sub'),
     *        email: apigateway.AccessLogField.contextAuthorizerClaims('email')
     *      }
     *   }))
     */
    static custom(format) {
        return new AccessLogFormat(format);
    }
    /**
     * Generate Common Log Format.
     */
    static clf() {
        const requester = [AccessLogField.contextIdentitySourceIp(), AccessLogField.contextIdentityCaller(), AccessLogField.contextIdentityUser()].join(' ');
        const requestTime = AccessLogField.contextRequestTime();
        const request = [AccessLogField.contextHttpMethod(), AccessLogField.contextResourcePath(), AccessLogField.contextProtocol()].join(' ');
        const status = [AccessLogField.contextStatus(), AccessLogField.contextResponseLength(), AccessLogField.contextRequestId()].join(' ');
        return new AccessLogFormat(`${requester} [${requestTime}] "${request}" ${status}`);
    }
    /**
     * Access log will be produced in the JSON format with a set of fields most useful in the access log. All fields are turned on by default with the
     * option to turn off specific fields.
     */
    static jsonWithStandardFields(fields = {
        ip: true,
        user: true,
        caller: true,
        requestTime: true,
        httpMethod: true,
        resourcePath: true,
        status: true,
        protocol: true,
        responseLength: true,
    }) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_JsonWithStandardFieldProps(fields);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.jsonWithStandardFields);
            }
            throw error;
        }
        return this.custom(JSON.stringify({
            requestId: AccessLogField.contextRequestId(),
            ip: fields.ip ? AccessLogField.contextIdentitySourceIp() : undefined,
            user: fields.user ? AccessLogField.contextIdentityUser() : undefined,
            caller: fields.caller ? AccessLogField.contextIdentityCaller() : undefined,
            requestTime: fields.requestTime ? AccessLogField.contextRequestTime() : undefined,
            httpMethod: fields.httpMethod ? AccessLogField.contextHttpMethod() : undefined,
            resourcePath: fields.resourcePath ? AccessLogField.contextResourcePath() : undefined,
            status: fields.status ? AccessLogField.contextStatus() : undefined,
            protocol: fields.protocol ? AccessLogField.contextProtocol() : undefined,
            responseLength: fields.responseLength ? AccessLogField.contextResponseLength() : undefined,
        }));
    }
    constructor(format) {
        this.format = format;
    }
    /**
     * Output a format string to be used with CloudFormation.
     */
    toString() {
        return this.format;
    }
}
_c = JSII_RTTI_SYMBOL_1;
AccessLogFormat[_c] = { fqn: "aws-cdk-lib.aws_apigateway.AccessLogFormat", version: "2.74.0" };
exports.AccessLogFormat = AccessLogFormat;
//# sourceMappingURL=data:application/json;base64,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