"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentitySource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents an identity source.
 *
 * The source can be specified either as a literal value (e.g: `Auth`) which
 * cannot be blank, or as an unresolved string token.
 */
class IdentitySource {
    /**
     * Provides a properly formatted header identity source.
     * @param headerName the name of the header the `IdentitySource` will represent.
     *
     * @returns a header identity source.
     */
    static header(headerName) {
        return IdentitySource.toString(headerName, 'method.request.header');
    }
    /**
     * Provides a properly formatted query string identity source.
     * @param queryString the name of the query string the `IdentitySource` will represent.
     *
     * @returns a query string identity source.
     */
    static queryString(queryString) {
        return IdentitySource.toString(queryString, 'method.request.querystring');
    }
    /**
     * Provides a properly formatted API Gateway stage variable identity source.
     * @param stageVariable the name of the stage variable the `IdentitySource` will represent.
     *
     * @returns an API Gateway stage variable identity source.
     */
    static stageVariable(stageVariable) {
        return IdentitySource.toString(stageVariable, 'stageVariables');
    }
    /**
     * Provides a properly formatted request context identity source.
     * @param context the name of the context variable the `IdentitySource` will represent.
     *
     * @returns a request context identity source.
     */
    static context(context) {
        return IdentitySource.toString(context, 'context');
    }
    static toString(source, type) {
        if (!source.trim()) {
            throw new Error('IdentitySources must be a non-empty string.');
        }
        return `${type}.${source}`;
    }
}
_a = JSII_RTTI_SYMBOL_1;
IdentitySource[_a] = { fqn: "aws-cdk-lib.aws_apigateway.IdentitySource", version: "2.74.0" };
exports.IdentitySource = IdentitySource;
//# sourceMappingURL=data:application/json;base64,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