"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasePathMapping = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
/**
 * This resource creates a base path that clients who call your API must use in
 * the invocation URL.
 *
 * Unless you're importing a domain with `DomainName.fromDomainNameAttributes()`,
 * you can use `DomainName.addBasePathMapping()` to define mappings.
 */
class BasePathMapping extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_BasePathMappingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BasePathMapping);
            }
            throw error;
        }
        if (props.basePath && !core_1.Token.isUnresolved(props.basePath)) {
            if (props.basePath.startsWith('/') || props.basePath.endsWith('/')) {
                throw new Error(`A base path cannot start or end with /", received: ${props.basePath}`);
            }
            if (props.basePath.match(/\/{2,}/)) {
                throw new Error(`A base path cannot have more than one consecutive /", received: ${props.basePath}`);
            }
            if (!props.basePath.match(/^[a-zA-Z0-9$_.+!*'()-/]+$/)) {
                throw new Error(`A base path may only contain letters, numbers, and one of "$-_.+!*'()/", received: ${props.basePath}`);
            }
        }
        const attachToStage = props.attachToStage ?? true;
        // if restApi is an owned API and it has a deployment stage, map all requests
        // to that stage. otherwise, the stage will have to be specified in the URL.
        // if props.attachToStage is false, then do not attach to the stage.
        const stage = props.stage ?? (props.restApi instanceof restapi_1.RestApiBase && attachToStage
            ? props.restApi.deploymentStage
            : undefined);
        new apigateway_generated_1.CfnBasePathMapping(this, 'Resource', {
            basePath: props.basePath,
            domainName: props.domainName.domainName,
            restApiId: props.restApi.restApiId,
            stage: stage?.stageName,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
BasePathMapping[_a] = { fqn: "aws-cdk-lib.aws_apigateway.BasePathMapping", version: "2.74.0" };
exports.BasePathMapping = BasePathMapping;
//# sourceMappingURL=data:application/json;base64,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