"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResponseType = exports.GatewayResponse = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const apigateway_generated_1 = require("./apigateway.generated");
/**
 * Configure the response received by clients, produced from the API Gateway backend.
 *
 * @resource AWS::ApiGateway::GatewayResponse
 */
class GatewayResponse extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_GatewayResponseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GatewayResponse);
            }
            throw error;
        }
        const gatewayResponseProps = {
            restApiId: props.restApi.restApiId,
            responseType: props.type.responseType,
            responseParameters: this.buildResponseParameters(props.responseHeaders),
            responseTemplates: props.templates,
            statusCode: props.statusCode,
        };
        const resource = new apigateway_generated_1.CfnGatewayResponse(this, 'Resource', gatewayResponseProps);
        const deployment = props.restApi.latestDeployment;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({
                gatewayResponse: {
                    ...gatewayResponseProps,
                },
            });
        }
        this.node.defaultChild = resource;
    }
    buildResponseParameters(responseHeaders) {
        if (!responseHeaders) {
            return undefined;
        }
        const responseParameters = {};
        for (const [header, value] of Object.entries(responseHeaders)) {
            responseParameters[`gatewayresponse.header.${header}`] = value;
        }
        return responseParameters;
    }
}
_a = JSII_RTTI_SYMBOL_1;
GatewayResponse[_a] = { fqn: "aws-cdk-lib.aws_apigateway.GatewayResponse", version: "2.74.0" };
exports.GatewayResponse = GatewayResponse;
/**
 * Supported types of gateway responses.
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html
 */
class ResponseType {
    /** A custom response type to support future cases. */
    static of(type) {
        return new ResponseType(type.toUpperCase());
    }
    constructor(type) {
        this.responseType = type;
    }
}
_b = JSII_RTTI_SYMBOL_1;
ResponseType[_b] = { fqn: "aws-cdk-lib.aws_apigateway.ResponseType", version: "2.74.0" };
/**
 * The gateway response for authorization failure.
 */
ResponseType.ACCESS_DENIED = new ResponseType('ACCESS_DENIED');
/**
 * The gateway response for an invalid API configuration.
 */
ResponseType.API_CONFIGURATION_ERROR = new ResponseType('API_CONFIGURATION_ERROR');
/**
 * The gateway response when a custom or Amazon Cognito authorizer failed to authenticate the caller.
 */
ResponseType.AUTHORIZER_FAILURE = new ResponseType('AUTHORIZER_FAILURE');
/**
 * The gateway response for failing to connect to a custom or Amazon Cognito authorizer.
 */
ResponseType.AUTHORIZER_CONFIGURATION_ERROR = new ResponseType('AUTHORIZER_CONFIGURATION_ERROR');
/**
 * The gateway response when the request parameter cannot be validated according to an enabled request validator.
 */
ResponseType.BAD_REQUEST_PARAMETERS = new ResponseType('BAD_REQUEST_PARAMETERS');
/**
 * The gateway response when the request body cannot be validated according to an enabled request validator.
 */
ResponseType.BAD_REQUEST_BODY = new ResponseType('BAD_REQUEST_BODY');
/**
 * The default gateway response for an unspecified response type with the status code of 4XX.
 */
ResponseType.DEFAULT_4XX = new ResponseType('DEFAULT_4XX');
/**
 * The default gateway response for an unspecified response type with a status code of 5XX.
 */
ResponseType.DEFAULT_5XX = new ResponseType('DEFAULT_5XX');
/**
 * The gateway response for an AWS authentication token expired error.
 */
ResponseType.EXPIRED_TOKEN = new ResponseType('EXPIRED_TOKEN');
/**
 * The gateway response for an invalid AWS signature error.
 */
ResponseType.INVALID_SIGNATURE = new ResponseType('INVALID_SIGNATURE');
/**
 * The gateway response for an integration failed error.
 */
ResponseType.INTEGRATION_FAILURE = new ResponseType('INTEGRATION_FAILURE');
/**
 * The gateway response for an integration timed out error.
 */
ResponseType.INTEGRATION_TIMEOUT = new ResponseType('INTEGRATION_TIMEOUT');
/**
 * The gateway response for an invalid API key submitted for a method requiring an API key.
 */
ResponseType.INVALID_API_KEY = new ResponseType('INVALID_API_KEY');
/**
 * The gateway response for a missing authentication token error,
 * including the cases when the client attempts to invoke an unsupported API method or resource.
 */
ResponseType.MISSING_AUTHENTICATION_TOKEN = new ResponseType('MISSING_AUTHENTICATION_TOKEN');
/**
 * The gateway response for the usage plan quota exceeded error.
 */
ResponseType.QUOTA_EXCEEDED = new ResponseType('QUOTA_EXCEEDED');
/**
 * The gateway response for the request too large error.
 */
ResponseType.REQUEST_TOO_LARGE = new ResponseType('REQUEST_TOO_LARGE');
/**
 * The gateway response when API Gateway cannot find the specified resource
 * after an API request passes authentication and authorization.
 */
ResponseType.RESOURCE_NOT_FOUND = new ResponseType('RESOURCE_NOT_FOUND');
/**
 * The gateway response when usage plan, method, stage, or account level throttling limits exceeded.
 */
ResponseType.THROTTLED = new ResponseType('THROTTLED');
/**
 * The gateway response when the custom or Amazon Cognito authorizer failed to authenticate the caller.
 */
ResponseType.UNAUTHORIZED = new ResponseType('UNAUTHORIZED');
/**
 * The gateway response when a payload is of an unsupported media type, if strict passthrough behavior is enabled.
 */
ResponseType.UNSUPPORTED_MEDIA_TYPE = new ResponseType('UNSUPPORTED_MEDIA_TYPE');
/**
 * The gateway response when a request is blocked by AWS WAF.
 */
ResponseType.WAF_FILTERED = new ResponseType('WAF_FILTERED');
exports.ResponseType = ResponseType;
//# sourceMappingURL=data:application/json;base64,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