"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpIntegration = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integration_1 = require("../integration");
/**
 * You can integrate an API method with an HTTP endpoint using the HTTP proxy
 * integration or the HTTP custom integration,.
 *
 * With the proxy integration, the setup is simple. You only need to set the
 * HTTP method and the HTTP endpoint URI, according to the backend requirements,
 * if you are not concerned with content encoding or caching.
 *
 * With the custom integration, the setup is more involved. In addition to the
 * proxy integration setup steps, you need to specify how the incoming request
 * data is mapped to the integration request and how the resulting integration
 * response data is mapped to the method response.
 */
class HttpIntegration extends integration_1.Integration {
    constructor(url, props = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_HttpIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpIntegration);
            }
            throw error;
        }
        const proxy = props.proxy ?? true;
        const method = props.httpMethod || 'GET';
        super({
            type: proxy ? integration_1.IntegrationType.HTTP_PROXY : integration_1.IntegrationType.HTTP,
            integrationHttpMethod: method,
            uri: url,
            options: props.options,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
HttpIntegration[_a] = { fqn: "aws-cdk-lib.aws_apigateway.HttpIntegration", version: "2.74.0" };
exports.HttpIntegration = HttpIntegration;
//# sourceMappingURL=data:application/json;base64,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