"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaRestApi = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integrations_1 = require("./integrations");
const restapi_1 = require("./restapi");
/**
 * Defines an API Gateway REST API with AWS Lambda proxy integration.
 *
 * Use the `proxy` property to define a greedy proxy ("{proxy+}") and "ANY"
 * method from the specified path. If not defined, you will need to explicity
 * add resources and methods to the API.
 */
class LambdaRestApi extends restapi_1.RestApi {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_LambdaRestApiProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaRestApi);
            }
            throw error;
        }
        if (props.options?.defaultIntegration || props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Lambda integration is automatically defined');
        }
        super(scope, id, {
            defaultIntegration: new integrations_1.LambdaIntegration(props.handler, props.integrationOptions),
            ...props.options,
            ...props,
        });
        if (props.proxy !== false) {
            this.root.addProxy();
            // Make sure users cannot call any other resource adding function
            this.root.addResource = addResourceThrows;
            this.root.addMethod = addMethodThrows;
            this.root.addProxy = addProxyThrows;
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
LambdaRestApi[_a] = { fqn: "aws-cdk-lib.aws_apigateway.LambdaRestApi", version: "2.74.0" };
exports.LambdaRestApi = LambdaRestApi;
function addResourceThrows() {
    throw new Error('Cannot call \'addResource\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addMethodThrows() {
    throw new Error('Cannot call \'addMethod\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addProxyThrows() {
    throw new Error('Cannot call \'addProxy\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
//# sourceMappingURL=data:application/json;base64,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