"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProxyResource = exports.Resource = exports.ResourceBase = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const apigateway_generated_1 = require("./apigateway.generated");
const cors_1 = require("./cors");
const integrations_1 = require("./integrations");
const method_1 = require("./method");
class ResourceBase extends core_1.Resource {
    constructor(scope, id) {
        super(scope, id);
        this.children = {};
    }
    addResource(pathPart, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_ResourceOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addResource);
            }
            throw error;
        }
        return new Resource(this, pathPart, { parent: this, pathPart, ...options });
    }
    addMethod(httpMethod, integration, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_Integration(integration);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_MethodOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addMethod);
            }
            throw error;
        }
        return new method_1.Method(this, httpMethod, { resource: this, httpMethod, integration, options });
    }
    addProxy(options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_ProxyResourceOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addProxy);
            }
            throw error;
        }
        return new ProxyResource(this, '{proxy+}', { parent: this, ...options });
    }
    addCorsPreflight(options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_CorsOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addCorsPreflight);
            }
            throw error;
        }
        const headers = {};
        //
        // Access-Control-Allow-Headers
        const allowHeaders = options.allowHeaders || cors_1.Cors.DEFAULT_HEADERS;
        headers['Access-Control-Allow-Headers'] = `'${allowHeaders.join(',')}'`;
        //
        // Access-Control-Allow-Origin
        if (options.allowOrigins.length === 0) {
            throw new Error('allowOrigins must contain at least one origin');
        }
        if (options.allowOrigins.includes('*') && options.allowOrigins.length > 1) {
            throw new Error(`Invalid "allowOrigins" - cannot mix "*" with specific origins: ${options.allowOrigins.join(',')}`);
        }
        // we use the first origin here and if there are more origins in the list, we
        // will match against them in the response velocity template
        const initialOrigin = options.allowOrigins[0];
        headers['Access-Control-Allow-Origin'] = `'${initialOrigin}'`;
        // the "Vary" header is required if we allow a specific origin
        // https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin#CORS_and_caching
        if (initialOrigin !== '*') {
            headers.Vary = '\'Origin\'';
        }
        //
        // Access-Control-Allow-Methods
        let allowMethods = options.allowMethods || cors_1.Cors.ALL_METHODS;
        if (allowMethods.includes('ANY')) {
            if (allowMethods.length > 1) {
                throw new Error(`ANY cannot be used with any other method. Received: ${allowMethods.join(',')}`);
            }
            allowMethods = cors_1.Cors.ALL_METHODS;
        }
        headers['Access-Control-Allow-Methods'] = `'${allowMethods.join(',')}'`;
        //
        // Access-Control-Allow-Credentials
        if (options.allowCredentials) {
            headers['Access-Control-Allow-Credentials'] = '\'true\'';
        }
        //
        // Access-Control-Max-Age
        let maxAgeSeconds;
        if (options.maxAge && options.disableCache) {
            throw new Error('The options "maxAge" and "disableCache" are mutually exclusive');
        }
        if (options.maxAge) {
            maxAgeSeconds = options.maxAge.toSeconds();
        }
        if (options.disableCache) {
            maxAgeSeconds = -1;
        }
        if (maxAgeSeconds) {
            headers['Access-Control-Max-Age'] = `'${maxAgeSeconds}'`;
        }
        //
        // Access-Control-Expose-Headers
        //
        if (options.exposeHeaders) {
            headers['Access-Control-Expose-Headers'] = `'${options.exposeHeaders.join(',')}'`;
        }
        //
        // statusCode
        const statusCode = options.statusCode ?? 204;
        //
        // prepare responseParams
        const integrationResponseParams = {};
        const methodResponseParams = {};
        for (const [name, value] of Object.entries(headers)) {
            const key = `method.response.header.${name}`;
            integrationResponseParams[key] = value;
            methodResponseParams[key] = true;
        }
        return this.addMethod('OPTIONS', new integrations_1.MockIntegration({
            requestTemplates: { 'application/json': '{ statusCode: 200 }' },
            integrationResponses: [
                { statusCode: `${statusCode}`, responseParameters: integrationResponseParams, responseTemplates: renderResponseTemplate() },
            ],
        }), {
            authorizer: {
                authorizerId: '',
                authorizationType: method_1.AuthorizationType.NONE,
            },
            apiKeyRequired: false,
            authorizationType: method_1.AuthorizationType.NONE,
            methodResponses: [
                { statusCode: `${statusCode}`, responseParameters: methodResponseParams },
            ],
        });
        // renders the response template to match all possible origins (if we have more than one)
        function renderResponseTemplate() {
            const origins = options.allowOrigins.slice(1);
            if (origins.length === 0) {
                return undefined;
            }
            const template = new Array();
            template.push('#set($origin = $input.params().header.get("Origin"))');
            template.push('#if($origin == "") #set($origin = $input.params().header.get("origin")) #end');
            const condition = origins.map(o => `$origin.matches("${o}")`).join(' || ');
            template.push(`#if(${condition})`);
            template.push('  #set($context.responseOverride.header.Access-Control-Allow-Origin = $origin)');
            template.push('#end');
            return {
                'application/json': template.join('\n'),
            };
        }
    }
    getResource(pathPart) {
        return this.children[pathPart];
    }
    /**
     * @internal
     */
    _trackChild(pathPart, resource) {
        this.children[pathPart] = resource;
    }
    resourceForPath(path) {
        if (!path) {
            return this;
        }
        if (path.startsWith('/')) {
            if (this.path !== '/') {
                throw new Error(`Path may start with "/" only for the resource, but we are at: ${this.path}`);
            }
            // trim trailing "/"
            return this.resourceForPath(path.slice(1));
        }
        const parts = path.split('/');
        const next = parts.shift();
        if (!next || next === '') {
            throw new Error('resourceForPath cannot be called with an empty path');
        }
        let resource = this.getResource(next);
        if (!resource) {
            resource = this.addResource(next);
        }
        return resource.resourceForPath(parts.join('/'));
    }
    /**
     * @deprecated - Throws error in some use cases that have been enabled since this deprecation notice. Use `RestApi.urlForPath()` instead.
     */
    get url() {
        return this.restApi.urlForPath(this.path);
    }
}
_a = JSII_RTTI_SYMBOL_1;
ResourceBase[_a] = { fqn: "aws-cdk-lib.aws_apigateway.ResourceBase", version: "2.74.0" };
exports.ResourceBase = ResourceBase;
class Resource extends ResourceBase {
    /**
     * Import an existing resource
     */
    static fromResourceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_ResourceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromResourceAttributes);
            }
            throw error;
        }
        class Import extends ResourceBase {
            constructor() {
                super(...arguments);
                this.api = attrs.restApi;
                this.resourceId = attrs.resourceId;
                this.path = attrs.path;
                this.defaultIntegration = undefined;
                this.defaultMethodOptions = undefined;
                this.defaultCorsPreflightOptions = undefined;
            }
            get parentResource() {
                throw new Error('parentResource is not configured for imported resource.');
            }
            get restApi() {
                throw new Error('restApi is not configured for imported resource.');
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_ResourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Resource);
            }
            throw error;
        }
        validateResourcePathPart(props.pathPart);
        this.parentResource = props.parent;
        if (props.parent instanceof ResourceBase) {
            props.parent._trackChild(props.pathPart, this);
        }
        const resourceProps = {
            restApiId: props.parent.api.restApiId,
            parentId: props.parent.resourceId,
            pathPart: props.pathPart,
        };
        const resource = new apigateway_generated_1.CfnResource(this, 'Resource', resourceProps);
        this.resourceId = resource.ref;
        this.api = props.parent.api;
        // render resource path (special case for root)
        this.path = props.parent.path;
        if (!this.path.endsWith('/')) {
            this.path += '/';
        }
        this.path += props.pathPart;
        const deployment = props.parent.api.latestDeployment;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({ resource: resourceProps });
        }
        // setup defaults based on properties and inherit from parent. method defaults
        // are inherited per property, so children can override piecemeal.
        this.defaultIntegration = props.defaultIntegration || props.parent.defaultIntegration;
        this.defaultMethodOptions = {
            ...props.parent.defaultMethodOptions,
            ...props.defaultMethodOptions,
        };
        this.defaultCorsPreflightOptions = props.defaultCorsPreflightOptions || props.parent.defaultCorsPreflightOptions;
        if (this.defaultCorsPreflightOptions) {
            this.addCorsPreflight(this.defaultCorsPreflightOptions);
        }
    }
    /**
     * The RestApi associated with this Resource
     * @deprecated - Throws an error if this Resource is not associated with an instance of `RestApi`. Use `api` instead.
     */
    get restApi() {
        if (!this.parentResource) {
            throw new Error('parentResource was unexpectedly not defined');
        }
        return this.parentResource.restApi;
    }
}
_b = JSII_RTTI_SYMBOL_1;
Resource[_b] = { fqn: "aws-cdk-lib.aws_apigateway.Resource", version: "2.74.0" };
exports.Resource = Resource;
/**
 * Defines a {proxy+} greedy resource and an ANY method on a route.
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-set-up-simple-proxy.html
 */
class ProxyResource extends Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            parent: props.parent,
            pathPart: '{proxy+}',
            defaultIntegration: props.defaultIntegration,
            defaultMethodOptions: props.defaultMethodOptions,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_ProxyResourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ProxyResource);
            }
            throw error;
        }
        const anyMethod = props.anyMethod ?? true;
        if (anyMethod) {
            this.anyMethod = this.addMethod('ANY');
        }
    }
    addMethod(httpMethod, integration, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_Integration(integration);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_MethodOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addMethod);
            }
            throw error;
        }
        // In case this proxy is mounted under the root, also add this method to
        // the root so that empty paths are proxied as well.
        if (this.parentResource && this.parentResource.path === '/') {
            // skip if the root resource already has this method defined
            if (!(this.parentResource.node.tryFindChild(httpMethod) instanceof method_1.Method)) {
                this.parentResource.addMethod(httpMethod, integration, options);
            }
        }
        return super.addMethod(httpMethod, integration, options);
    }
}
_c = JSII_RTTI_SYMBOL_1;
ProxyResource[_c] = { fqn: "aws-cdk-lib.aws_apigateway.ProxyResource", version: "2.74.0" };
exports.ProxyResource = ProxyResource;
function validateResourcePathPart(part) {
    // strip {} which indicate this is a parameter
    if (part.startsWith('{') && part.endsWith('}')) {
        part = part.slice(1, -1);
        // proxy resources are allowed to end with a '+'
        if (part.endsWith('+')) {
            part = part.slice(0, -1);
        }
    }
    if (!/^[a-zA-Z0-9:\.\_\-]+$/.test(part)) {
        throw new Error(`Resource's path part only allow [a-zA-Z0-9:._-], an optional trailing '+'
      and curly braces at the beginning and the end: ${part}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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