"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PredefinedMetric = exports.TargetTrackingScalingPolicy = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const constructs_1 = require("constructs");
const applicationautoscaling_generated_1 = require("./applicationautoscaling.generated");
class TargetTrackingScalingPolicy extends constructs_1.Construct {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_applicationautoscaling_TargetTrackingScalingPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TargetTrackingScalingPolicy);
            }
            throw error;
        }
        if ((props.customMetric === undefined) === (props.predefinedMetric === undefined)) {
            throw new Error('Exactly one of \'customMetric\' or \'predefinedMetric\' must be specified.');
        }
        if (props.customMetric && !props.customMetric.toMetricConfig().metricStat) {
            throw new Error('Only direct metrics are supported for Target Tracking. Use Step Scaling or supply a Metric object.');
        }
        super(scope, id);
        // replace dummy value in DYNAMODB_WRITE_CAPACITY_UTILIZATION due to a jsii bug (https://github.com/aws/jsii/issues/2782)
        const predefinedMetric = props.predefinedMetric === PredefinedMetric.DYNAMODB_WRITE_CAPACITY_UTILIZATION ?
            PredefinedMetric.DYANMODB_WRITE_CAPACITY_UTILIZATION :
            props.predefinedMetric;
        const resource = new applicationautoscaling_generated_1.CfnScalingPolicy(this, 'Resource', {
            policyName: props.policyName || cdk.Names.uniqueId(this),
            policyType: 'TargetTrackingScaling',
            scalingTargetId: props.scalingTarget.scalableTargetId,
            targetTrackingScalingPolicyConfiguration: {
                customizedMetricSpecification: renderCustomMetric(props.customMetric),
                disableScaleIn: props.disableScaleIn,
                predefinedMetricSpecification: predefinedMetric !== undefined ? {
                    predefinedMetricType: predefinedMetric,
                    resourceLabel: props.resourceLabel,
                } : undefined,
                scaleInCooldown: props.scaleInCooldown && props.scaleInCooldown.toSeconds(),
                scaleOutCooldown: props.scaleOutCooldown && props.scaleOutCooldown.toSeconds(),
                targetValue: props.targetValue,
            },
        });
        this.scalingPolicyArn = resource.ref;
    }
}
_a = JSII_RTTI_SYMBOL_1;
TargetTrackingScalingPolicy[_a] = { fqn: "aws-cdk-lib.aws_applicationautoscaling.TargetTrackingScalingPolicy", version: "2.74.0" };
exports.TargetTrackingScalingPolicy = TargetTrackingScalingPolicy;
function renderCustomMetric(metric) {
    if (!metric) {
        return undefined;
    }
    const c = metric.toMetricConfig().metricStat;
    if (c.statistic.startsWith('p')) {
        throw new Error(`Cannot use statistic '${c.statistic}' for Target Tracking: only 'Average', 'Minimum', 'Maximum', 'SampleCount', and 'Sum' are supported.`);
    }
    return {
        dimensions: c.dimensions,
        metricName: c.metricName,
        namespace: c.namespace,
        statistic: c.statistic,
        unit: c.unitFilter,
    };
}
/**
 * One of the predefined autoscaling metrics
 */
var PredefinedMetric;
(function (PredefinedMetric) {
    /**
     * Average percentage of instances in an AppStream fleet that are being used.
     */
    PredefinedMetric["APPSTREAM_AVERAGE_CAPACITY_UTILIZATION"] = "AppStreamAverageCapacityUtilization";
    /**
     * Percentage of provisioned read capacity units utilized by a Keyspaces table.
     */
    PredefinedMetric["CASSANDRA_READ_CAPACITY_UTILIZATION"] = "CassandraReadCapacityUtilization";
    /**
     * Percentage of provisioned write capacity units utilized by a Keyspaces table.
     */
    PredefinedMetric["CASSANDRA_WRITE_CAPACITY_UTILIZATION"] = "CassandraWriteCapacityUtilization";
    /**
     * Percentage of provisioned inference units utilized by a Comprehend endpoint.
     */
    PredefinedMetric["COMPREHEND_INFERENCE_UTILIZATION"] = "ComprehendInferenceUtilization";
    /**
     * Average CPU Utilization of read replica instances in a Neptune DB cluster.
     */
    PredefinedMetric["NEPTURE_READER_AVERAGE_CPU_UTILIZATION"] = "NeptuneReaderAverageCPUUtilization";
    /**
     * Percentage of provisioned read capacity units consumed by a DynamoDB table.
     */
    PredefinedMetric["DYNAMODB_READ_CAPACITY_UTILIZATION"] = "DynamoDBReadCapacityUtilization";
    /**
     * Percentage of provisioned write capacity units consumed by a DynamoDB table.
     *
     * Suffix `dummy` is necessary due to jsii bug (https://github.com/aws/jsii/issues/2782).
     * Duplicate values will be dropped, so this suffix is added as a workaround.
     * The value will be replaced when this enum is used.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["DYNAMODB_WRITE_CAPACITY_UTILIZATION"] = "DynamoDBWriteCapacityUtilization-dummy";
    /**
     * DYANMODB_WRITE_CAPACITY_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @deprecated use `PredefinedMetric.DYNAMODB_WRITE_CAPACITY_UTILIZATION`
     */
    PredefinedMetric["DYANMODB_WRITE_CAPACITY_UTILIZATION"] = "DynamoDBWriteCapacityUtilization";
    /**
     * ALB_REQUEST_COUNT_PER_TARGET
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["ALB_REQUEST_COUNT_PER_TARGET"] = "ALBRequestCountPerTarget";
    /**
     * RDS_READER_AVERAGE_CPU_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["RDS_READER_AVERAGE_CPU_UTILIZATION"] = "RDSReaderAverageCPUUtilization";
    /**
     * RDS_READER_AVERAGE_DATABASE_CONNECTIONS
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["RDS_READER_AVERAGE_DATABASE_CONNECTIONS"] = "RDSReaderAverageDatabaseConnections";
    /**
     * EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION"] = "EC2SpotFleetRequestAverageCPUUtilization";
    /**
     * EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN"] = "EC2SpotFleetRequestAverageNetworkIn";
    /**
     * EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT"] = "EC2SpotFleetRequestAverageNetworkOut";
    /**
     * SAGEMAKER_VARIANT_INVOCATIONS_PER_INSTANCE
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["SAGEMAKER_VARIANT_INVOCATIONS_PER_INSTANCE"] = "SageMakerVariantInvocationsPerInstance";
    /**
     * ECS_SERVICE_AVERAGE_CPU_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["ECS_SERVICE_AVERAGE_CPU_UTILIZATION"] = "ECSServiceAverageCPUUtilization";
    /**
     * ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION"] = "ECSServiceAverageMemoryUtilization";
    /**
     * LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION
     * @see https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics.html#monitoring-metrics-concurrency
     */
    PredefinedMetric["LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION"] = "LambdaProvisionedConcurrencyUtilization";
    /**
     * KAFKA_BROKER_STORAGE_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["KAFKA_BROKER_STORAGE_UTILIZATION"] = "KafkaBrokerStorageUtilization";
    /**
     * ELASTIC_CACHE_PRIMARY_ENGINE_CPU_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["ELASTICACHE_PRIMARY_ENGINE_CPU_UTILIZATION"] = "ElastiCachePrimaryEngineCPUUtilization";
    /**
     * ELASTIC_CACHE_REPLICA_ENGINE_CPU_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["ELASTICACHE_REPLICA_ENGINE_CPU_UTILIZATION"] = "ElastiCacheReplicaEngineCPUUtilization";
    /**
     * ELASTIC_CACHE_REPLICA_ENGINE_CPU_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["ELASTICACHE_DATABASE_MEMORY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE"] = "ElastiCacheDatabaseMemoryUsageCountedForEvictPercentage";
})(PredefinedMetric = exports.PredefinedMetric || (exports.PredefinedMetric = {}));
//# sourceMappingURL=data:application/json;base64,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