"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeaderMatch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Used to generate header matching methods.
 */
class HeaderMatch {
    /**
     * The value of the header with the given name in the request must match the
     * specified value exactly.
     *
     * @param headerName the name of the header to match against
     * @param headerValue The exact value to test against
     */
    static valueIs(headerName, headerValue) {
        return new HeaderMatchImpl(headerName, false, { exact: headerValue });
    }
    /**
     * The value of the header with the given name in the request must not match
     * the specified value exactly.
     *
     * @param headerName the name of the header to match against
     * @param headerValue The exact value to test against
     */
    static valueIsNot(headerName, headerValue) {
        return new HeaderMatchImpl(headerName, true, { exact: headerValue });
    }
    /**
     * The value of the header with the given name in the request must start with
     * the specified characters.
     *
     * @param headerName the name of the header to match against
     * @param prefix The prefix to test against
     */
    static valueStartsWith(headerName, prefix) {
        return new HeaderMatchImpl(headerName, false, { prefix });
    }
    /**
     * The value of the header with the given name in the request must not start
     * with the specified characters.
     *
     * @param headerName the name of the header to match against
     * @param prefix The prefix to test against
     */
    static valueDoesNotStartWith(headerName, prefix) {
        return new HeaderMatchImpl(headerName, true, { prefix });
    }
    /**
     * The value of the header with the given name in the request must end with
     * the specified characters.
     *
     * @param headerName the name of the header to match against
     * @param suffix The suffix to test against
     */
    static valueEndsWith(headerName, suffix) {
        return new HeaderMatchImpl(headerName, false, { suffix });
    }
    /**
     * The value of the header with the given name in the request must not end
     * with the specified characters.
     *
     * @param headerName the name of the header to match against
     * @param suffix The suffix to test against
     */
    static valueDoesNotEndWith(headerName, suffix) {
        return new HeaderMatchImpl(headerName, true, { suffix });
    }
    /**
     * The value of the header with the given name in the request must include
     * the specified characters.
     *
     * @param headerName the name of the header to match against
     * @param regex The regex to test against
     */
    static valueMatchesRegex(headerName, regex) {
        return new HeaderMatchImpl(headerName, false, { regex });
    }
    /**
     * The value of the header with the given name in the request must not
     * include the specified characters.
     *
     * @param headerName the name of the header to match against
     * @param regex The regex to test against
     */
    static valueDoesNotMatchRegex(headerName, regex) {
        return new HeaderMatchImpl(headerName, true, { regex });
    }
    /**
     * The value of the header with the given name in the request must be in a
     * range of values.
     *
     * @param headerName the name of the header to match against
     * @param start Match on values starting at and including this value
     * @param end Match on values up to but not including this value
     */
    static valuesIsInRange(headerName, start, end) {
        return new HeaderMatchImpl(headerName, false, {
            range: {
                start,
                end,
            },
        });
    }
    /**
     * The value of the header with the given name in the request must not be in
     * a range of values.
     *
     * @param headerName the name of the header to match against
     * @param start Match on values starting at and including this value
     * @param end Match on values up to but not including this value
     */
    static valuesIsNotInRange(headerName, start, end) {
        return new HeaderMatchImpl(headerName, true, {
            range: {
                start,
                end,
            },
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
HeaderMatch[_a] = { fqn: "aws-cdk-lib.aws_appmesh.HeaderMatch", version: "2.74.0" };
exports.HeaderMatch = HeaderMatch;
class HeaderMatchImpl extends HeaderMatch {
    constructor(headerName, invert, matchProperty) {
        super();
        this.headerName = headerName;
        this.invert = invert;
        this.matchProperty = matchProperty;
    }
    bind(_scope) {
        return {
            headerMatch: {
                name: this.headerName,
                invert: this.invert,
                match: this.matchProperty,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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