"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HealthCheck = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * Contains static factory methods for creating health checks for different protocols
 */
class HealthCheck {
    /**
     * Construct a HTTP health check
     */
    static http(options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appmesh_HttpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http);
            }
            throw error;
        }
        return new HealthCheckImpl(shared_interfaces_1.Protocol.HTTP, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout, options.path);
    }
    /**
     * Construct a HTTP2 health check
     */
    static http2(options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appmesh_HttpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http2);
            }
            throw error;
        }
        return new HealthCheckImpl(shared_interfaces_1.Protocol.HTTP2, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout, options.path);
    }
    /**
     * Construct a GRPC health check
     */
    static grpc(options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appmesh_GrpcHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.grpc);
            }
            throw error;
        }
        return new HealthCheckImpl(shared_interfaces_1.Protocol.GRPC, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout);
    }
    /**
     * Construct a TCP health check
     */
    static tcp(options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appmesh_TcpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.tcp);
            }
            throw error;
        }
        return new HealthCheckImpl(shared_interfaces_1.Protocol.TCP, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout);
    }
}
_a = JSII_RTTI_SYMBOL_1;
HealthCheck[_a] = { fqn: "aws-cdk-lib.aws_appmesh.HealthCheck", version: "2.74.0" };
exports.HealthCheck = HealthCheck;
class HealthCheckImpl extends HealthCheck {
    constructor(protocol, healthyThreshold = 2, unhealthyThreshold = 2, interval = cdk.Duration.seconds(5), timeout = cdk.Duration.seconds(2), path) {
        super();
        this.protocol = protocol;
        this.healthyThreshold = healthyThreshold;
        this.unhealthyThreshold = unhealthyThreshold;
        this.interval = interval;
        this.timeout = timeout;
        this.path = path;
        if (healthyThreshold < 2 || healthyThreshold > 10) {
            throw new Error('healthyThreshold must be between 2 and 10');
        }
        if (unhealthyThreshold < 2 || unhealthyThreshold > 10) {
            throw new Error('unhealthyThreshold must be between 2 and 10');
        }
        if (interval.toMilliseconds() < 5000 || interval.toMilliseconds() > 300000) {
            throw new Error('interval must be between 5 seconds and 300 seconds');
        }
        if (timeout.toMilliseconds() < 2000 || timeout.toMilliseconds() > 60000) {
            throw new Error('timeout must be between 2 seconds and 60 seconds');
        }
        // Default to / for HTTP Health Checks
        if (path === undefined && (protocol === shared_interfaces_1.Protocol.HTTP || protocol === shared_interfaces_1.Protocol.HTTP2)) {
            this.path = '/';
        }
    }
    bind(_scope, options) {
        return {
            virtualNodeHealthCheck: {
                protocol: this.protocol,
                healthyThreshold: this.healthyThreshold,
                unhealthyThreshold: this.unhealthyThreshold,
                intervalMillis: this.interval.toMilliseconds(),
                timeoutMillis: this.timeout.toMilliseconds(),
                path: this.path,
                port: options.defaultPort,
            },
            virtualGatewayHealthCheck: {
                protocol: this.protocol,
                healthyThreshold: this.healthyThreshold,
                unhealthyThreshold: this.unhealthyThreshold,
                intervalMillis: this.interval.toMilliseconds(),
                timeoutMillis: this.timeout.toMilliseconds(),
                path: this.path,
                port: options.defaultPort,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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