"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueryParameterMatch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Used to generate query parameter matching methods.
 */
class QueryParameterMatch {
    /**
     * The value of the query parameter with the given name in the request must match the
     * specified value exactly.
     *
     * @param queryParameterName the name of the query parameter to match against
     * @param queryParameterValue The exact value to test against
     */
    static valueIs(queryParameterName, queryParameterValue) {
        return new QueryParameterMatchImpl(queryParameterName, { exact: queryParameterValue });
    }
}
_a = JSII_RTTI_SYMBOL_1;
QueryParameterMatch[_a] = { fqn: "aws-cdk-lib.aws_appmesh.QueryParameterMatch", version: "2.74.0" };
exports.QueryParameterMatch = QueryParameterMatch;
class QueryParameterMatchImpl extends QueryParameterMatch {
    constructor(queryParameterName, matchProperty) {
        super();
        this.queryParameterName = queryParameterName;
        this.matchProperty = matchProperty;
    }
    bind(_scope) {
        return {
            queryParameterMatch: {
                match: this.matchProperty,
                name: this.queryParameterName,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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