"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const appmesh_generated_1 = require("./appmesh.generated");
const utils_1 = require("./private/utils");
const virtual_router_1 = require("./virtual-router");
/**
 * Route represents a new or existing route attached to a VirtualRouter and Mesh
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html
 */
class Route extends cdk.Resource {
    /**
     * Import an existing Route given an ARN
     */
    static fromRouteArn(scope, id, routeArn) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.routeArn = routeArn;
                this.virtualRouter = virtual_router_1.VirtualRouter.fromVirtualRouterArn(this, 'VirtualRouter', routeArn);
                this.routeName = cdk.Fn.select(4, cdk.Fn.split('/', cdk.Stack.of(scope).splitArn(routeArn, cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName));
            }
        }(scope, id);
    }
    /**
     * Import an existing Route given attributes
     */
    static fromRouteAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appmesh_RouteAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromRouteAttributes);
            }
            throw error;
        }
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.routeName = attrs.routeName;
                this.virtualRouter = attrs.virtualRouter;
                this.routeArn = cdk.Stack.of(this).formatArn({
                    service: 'appmesh',
                    resource: `mesh/${attrs.virtualRouter.mesh.meshName}/virtualRouter/${attrs.virtualRouter.virtualRouterName}/route`,
                    resourceName: this.routeName,
                });
            }
        }(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.routeName || cdk.Lazy.string({ produce: () => cdk.Names.uniqueId(this) }),
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appmesh_RouteProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Route);
            }
            throw error;
        }
        this.virtualRouter = props.virtualRouter;
        const spec = props.routeSpec.bind(this);
        const route = new appmesh_generated_1.CfnRoute(this, 'Resource', {
            routeName: this.physicalName,
            meshName: this.virtualRouter.mesh.meshName,
            meshOwner: (0, utils_1.renderMeshOwner)(this.env.account, this.virtualRouter.mesh.env.account),
            virtualRouterName: this.virtualRouter.virtualRouterName,
            spec: {
                tcpRoute: spec.tcpRouteSpec,
                httpRoute: spec.httpRouteSpec,
                http2Route: spec.http2RouteSpec,
                grpcRoute: spec.grpcRouteSpec,
                priority: spec.priority,
            },
        });
        this.routeName = this.getResourceNameAttribute(route.attrRouteName);
        this.routeArn = this.getResourceArnAttribute(route.ref, {
            service: 'appmesh',
            resource: `mesh/${props.mesh.meshName}/virtualRouter/${props.virtualRouter.virtualRouterName}/route`,
            resourceName: this.physicalName,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
Route[_a] = { fqn: "aws-cdk-lib.aws_appmesh.Route", version: "2.74.0" };
exports.Route = Route;
//# sourceMappingURL=data:application/json;base64,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