"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubjectAlternativeNames = exports.MutualTlsValidationTrust = exports.TlsValidationTrust = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines the TLS Validation Context Trust.
 */
class TlsValidationTrust {
    /**
     * Tells envoy where to fetch the validation context from
     */
    static file(certificateChain) {
        return new TlsValidationFileTrust(certificateChain);
    }
    /**
     * TLS Validation Context Trust for ACM Private Certificate Authority (CA).
     */
    static acm(certificateAuthorities) {
        return new TlsValidationAcmTrust(certificateAuthorities);
    }
    /**
     * TLS Validation Context Trust for Envoy' service discovery service.
     */
    static sds(secretName) {
        return new TlsValidationSdsTrust(secretName);
    }
}
_a = JSII_RTTI_SYMBOL_1;
TlsValidationTrust[_a] = { fqn: "aws-cdk-lib.aws_appmesh.TlsValidationTrust", version: "2.74.0" };
exports.TlsValidationTrust = TlsValidationTrust;
/**
 * Represents a TLS Validation Context Trust that is supported for mutual TLS authentication.
 */
class MutualTlsValidationTrust extends TlsValidationTrust {
    constructor() {
        super(...arguments);
        // TypeScript uses structural typing, so we need a property different from TlsValidationTrust
        this.differentiator = false;
    }
}
_b = JSII_RTTI_SYMBOL_1;
MutualTlsValidationTrust[_b] = { fqn: "aws-cdk-lib.aws_appmesh.MutualTlsValidationTrust", version: "2.74.0" };
exports.MutualTlsValidationTrust = MutualTlsValidationTrust;
class TlsValidationAcmTrust extends TlsValidationTrust {
    constructor(certificateAuthorities) {
        super();
        this.certificateAuthorities = certificateAuthorities;
    }
    bind(_scope) {
        if (this.certificateAuthorities.length === 0) {
            throw new Error('you must provide at least one Certificate Authority when creating an ACM Trust ClientPolicy');
        }
        else {
            return {
                tlsValidationTrust: {
                    acm: {
                        certificateAuthorityArns: this.certificateAuthorities.map(certificateArn => certificateArn.certificateAuthorityArn),
                    },
                },
            };
        }
    }
}
class TlsValidationFileTrust extends MutualTlsValidationTrust {
    constructor(certificateChain) {
        super();
        this.certificateChain = certificateChain;
    }
    bind(_scope) {
        return {
            tlsValidationTrust: {
                file: {
                    certificateChain: this.certificateChain,
                },
            },
        };
    }
}
class TlsValidationSdsTrust extends MutualTlsValidationTrust {
    constructor(secretName) {
        super();
        this.secretName = secretName;
    }
    bind(_scope) {
        return {
            tlsValidationTrust: {
                sds: {
                    secretName: this.secretName,
                },
            },
        };
    }
}
/**
 * Used to generate Subject Alternative Names Matchers
 */
class SubjectAlternativeNames {
    /**
     * The values of the SAN must match the specified values exactly.
     *
     * @param names The exact values to test against.
     */
    static matchingExactly(...names) {
        return new SubjectAlternativeNamesImpl({ exact: names });
    }
}
_c = JSII_RTTI_SYMBOL_1;
SubjectAlternativeNames[_c] = { fqn: "aws-cdk-lib.aws_appmesh.SubjectAlternativeNames", version: "2.74.0" };
exports.SubjectAlternativeNames = SubjectAlternativeNames;
class SubjectAlternativeNamesImpl extends SubjectAlternativeNames {
    constructor(matchProperty) {
        super();
        this.matchProperty = matchProperty;
    }
    bind(_scope) {
        return {
            subjectAlternativeNamesMatch: this.matchProperty,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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