"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualGatewayListener = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("./private/utils");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * Represents the properties needed to define listeners for a VirtualGateway
 */
class VirtualGatewayListener {
    /**
     * Returns an HTTP Listener for a VirtualGateway
     */
    static http(options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appmesh_HttpGatewayListenerOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http);
            }
            throw error;
        }
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP, options.healthCheck, options.port, options.tls, options.connectionPool);
    }
    /**
     * Returns an HTTP2 Listener for a VirtualGateway
     */
    static http2(options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appmesh_Http2GatewayListenerOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http2);
            }
            throw error;
        }
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP2, options.healthCheck, options.port, options.tls, options.connectionPool);
    }
    /**
     * Returns a GRPC Listener for a VirtualGateway
     */
    static grpc(options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appmesh_GrpcGatewayListenerOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.grpc);
            }
            throw error;
        }
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.GRPC, options.healthCheck, options.port, options.tls, options.connectionPool);
    }
}
_a = JSII_RTTI_SYMBOL_1;
VirtualGatewayListener[_a] = { fqn: "aws-cdk-lib.aws_appmesh.VirtualGatewayListener", version: "2.74.0" };
exports.VirtualGatewayListener = VirtualGatewayListener;
/**
 * Represents the properties needed to define an HTTP Listener for a VirtualGateway
 */
class VirtualGatewayListenerImpl extends VirtualGatewayListener {
    constructor(protocol, healthCheck, port = 8080, listenerTls, connectionPool) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.port = port;
        this.listenerTls = listenerTls;
        this.connectionPool = connectionPool;
    }
    /**
     * Called when the GatewayListener type is initialized. Can be used to enforce
     * mutual exclusivity
     */
    bind(scope) {
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: this.healthCheck?.bind(scope, { defaultPort: this.port }).virtualGatewayHealthCheck,
                tls: (0, utils_1.renderListenerTlsOptions)(scope, this.listenerTls),
                connectionPool: this.connectionPool ? renderConnectionPool(this.connectionPool, this.protocol) : undefined,
            },
        };
    }
}
function renderConnectionPool(connectionPool, listenerProtocol) {
    return ({
        [listenerProtocol]: {
            maxRequests: connectionPool?.maxRequests !== undefined ? connectionPool.maxRequests : undefined,
            maxConnections: connectionPool?.maxConnections !== undefined ? connectionPool.maxConnections : undefined,
            maxPendingRequests: connectionPool?.maxPendingRequests !== undefined ? connectionPool.maxPendingRequests : undefined,
        },
    });
}
//# sourceMappingURL=data:application/json;base64,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