"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualNodeListener = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("./private/utils");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 *  Defines listener for a VirtualNode
 */
class VirtualNodeListener {
    /**
     * Returns an HTTP Listener for a VirtualNode
     */
    static http(props = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appmesh_HttpVirtualNodeListenerOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http);
            }
            throw error;
        }
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an HTTP2 Listener for a VirtualNode
     */
    static http2(props = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appmesh_Http2VirtualNodeListenerOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http2);
            }
            throw error;
        }
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP2, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an GRPC Listener for a VirtualNode
     */
    static grpc(props = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appmesh_GrpcVirtualNodeListenerOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.grpc);
            }
            throw error;
        }
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.GRPC, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an TCP Listener for a VirtualNode
     */
    static tcp(props = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appmesh_TcpVirtualNodeListenerOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.tcp);
            }
            throw error;
        }
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.TCP, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
}
_a = JSII_RTTI_SYMBOL_1;
VirtualNodeListener[_a] = { fqn: "aws-cdk-lib.aws_appmesh.VirtualNodeListener", version: "2.74.0" };
exports.VirtualNodeListener = VirtualNodeListener;
class VirtualNodeListenerImpl extends VirtualNodeListener {
    constructor(protocol, healthCheck, timeout, port = 8080, tls, outlierDetection, connectionPool) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.timeout = timeout;
        this.port = port;
        this.tls = tls;
        this.outlierDetection = outlierDetection;
        this.connectionPool = connectionPool;
    }
    bind(scope) {
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: this.healthCheck?.bind(scope, { defaultPort: this.port }).virtualNodeHealthCheck,
                timeout: this.timeout ? this.renderTimeout(this.timeout) : undefined,
                tls: (0, utils_1.renderListenerTlsOptions)(scope, this.tls),
                outlierDetection: this.outlierDetection ? this.renderOutlierDetection(this.outlierDetection) : undefined,
                connectionPool: this.connectionPool ? this.renderConnectionPool(this.connectionPool) : undefined,
            },
        };
    }
    renderTimeout(timeout) {
        return ({
            [this.protocol]: {
                idle: timeout?.idle !== undefined ? {
                    unit: 'ms',
                    value: timeout?.idle.toMilliseconds(),
                } : undefined,
                perRequest: timeout?.perRequest !== undefined ? {
                    unit: 'ms',
                    value: timeout?.perRequest.toMilliseconds(),
                } : undefined,
            },
        });
    }
    renderOutlierDetection(outlierDetection) {
        return {
            baseEjectionDuration: {
                unit: 'ms',
                value: outlierDetection.baseEjectionDuration.toMilliseconds(),
            },
            interval: {
                unit: 'ms',
                value: outlierDetection.interval.toMilliseconds(),
            },
            maxEjectionPercent: outlierDetection.maxEjectionPercent,
            maxServerErrors: outlierDetection.maxServerErrors,
        };
    }
    renderConnectionPool(connectionPool) {
        return ({
            [this.protocol]: {
                maxRequests: connectionPool?.maxRequests !== undefined ? connectionPool.maxRequests : undefined,
                maxConnections: connectionPool?.maxConnections !== undefined ? connectionPool.maxConnections : undefined,
                maxPendingRequests: connectionPool?.maxPendingRequests !== undefined ? connectionPool.maxPendingRequests : undefined,
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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