"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualRouterListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * Represents the properties needed to define listeners for a VirtualRouter
 */
class VirtualRouterListener {
    /**
     * Returns an HTTP Listener for a VirtualRouter
     *
     * @param port the optional port of the listener, 8080 by default
     */
    static http(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.HTTP, port);
    }
    /**
     * Returns an HTTP2 Listener for a VirtualRouter
     *
     * @param port the optional port of the listener, 8080 by default
     */
    static http2(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.HTTP2, port);
    }
    /**
     * Returns a GRPC Listener for a VirtualRouter
     *
     * @param port the optional port of the listener, 8080 by default
     */
    static grpc(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.GRPC, port);
    }
    /**
     * Returns a TCP Listener for a VirtualRouter
     *
     * @param port the optional port of the listener, 8080 by default
     */
    static tcp(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.TCP, port);
    }
}
_a = JSII_RTTI_SYMBOL_1;
VirtualRouterListener[_a] = { fqn: "aws-cdk-lib.aws_appmesh.VirtualRouterListener", version: "2.74.0" };
exports.VirtualRouterListener = VirtualRouterListener;
class VirtualRouterListenerImpl extends VirtualRouterListener {
    constructor(protocol, port) {
        super();
        this.protocol = protocol;
        this.port = port ?? 8080;
    }
    bind(_scope) {
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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