"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppsyncFunction = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const appsync_generated_1 = require("./appsync.generated");
/**
 * AppSync Functions are local functions that perform certain operations
 * onto a backend data source. Developers can compose operations (Functions)
 * and execute them in sequence with Pipeline Resolvers.
 *
 * @resource AWS::AppSync::FunctionConfiguration
 */
class AppsyncFunction extends core_1.Resource {
    /**
     * Import Appsync Function from arn
     */
    static fromAppsyncFunctionAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_AppsyncFunctionAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAppsyncFunctionAttributes);
            }
            throw error;
        }
        class Import extends core_1.Resource {
            constructor(s, i) {
                super(s, i);
                this.functionId = core_1.Lazy.stringValue({
                    produce: () => core_1.Fn.select(3, core_1.Fn.split('/', attrs.functionArn)),
                });
                this.functionArn = attrs.functionArn;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_AppsyncFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AppsyncFunction);
            }
            throw error;
        }
        // If runtime is specified, code must also be
        if (props.runtime && !props.code) {
            throw new Error('Code is required when specifying a runtime');
        }
        if (props.code && (props.requestMappingTemplate || props.responseMappingTemplate)) {
            throw new Error('Mapping templates cannot be used alongside code');
        }
        const code = props.code?.bind(this);
        this.function = new appsync_generated_1.CfnFunctionConfiguration(this, 'Resource', {
            name: props.name,
            description: props.description,
            apiId: props.api.apiId,
            dataSourceName: props.dataSource.name,
            runtime: props.runtime?.toProperties(),
            codeS3Location: code?.s3Location,
            code: code?.inlineCode,
            functionVersion: '2018-05-29',
            requestMappingTemplate: props.requestMappingTemplate?.renderTemplate(),
            responseMappingTemplate: props.responseMappingTemplate?.renderTemplate(),
        });
        this.functionName = this.function.attrName;
        this.functionArn = this.function.attrFunctionArn;
        this.functionId = this.function.attrFunctionId;
        this.dataSource = props.dataSource;
        this.function.addDependency(this.dataSource.ds);
        props.api.addSchemaDependency(this.function);
    }
}
_a = JSII_RTTI_SYMBOL_1;
AppsyncFunction[_a] = { fqn: "aws-cdk-lib.aws_appsync.AppsyncFunction", version: "2.74.0" };
exports.AppsyncFunction = AppsyncFunction;
//# sourceMappingURL=data:application/json;base64,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