"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenSearchDataSource = exports.ElasticsearchDataSource = exports.RdsDataSource = exports.LambdaDataSource = exports.HttpDataSource = exports.DynamoDbDataSource = exports.NoneDataSource = exports.BackedDataSource = exports.BaseDataSource = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("../../aws-iam");
const core_1 = require("../../core");
const constructs_1 = require("constructs");
const appsync_function_1 = require("./appsync-function");
const appsync_generated_1 = require("./appsync.generated");
const resolver_1 = require("./resolver");
/**
 * Abstract AppSync datasource implementation. Do not use directly but use subclasses for concrete datasources
 */
class BaseDataSource extends constructs_1.Construct {
    constructor(scope, id, props, extended) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_BackedDataSourceProps(props);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_ExtendedDataSourceProps(extended);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BaseDataSource);
            }
            throw error;
        }
        if (extended.type !== 'NONE') {
            this.serviceRole = props.serviceRole || new aws_iam_1.Role(this, 'ServiceRole', { assumedBy: new aws_iam_1.ServicePrincipal('appsync.amazonaws.com') });
        }
        // Replace unsupported characters from DataSource name. The only allowed pattern is: {[_A-Za-z][_0-9A-Za-z]*}
        const name = (props.name ?? id);
        const supportedName = core_1.Token.isUnresolved(name) ? name : name.replace(/[\W]+/g, '');
        this.ds = new appsync_generated_1.CfnDataSource(this, 'Resource', {
            apiId: props.api.apiId,
            name: supportedName,
            description: props.description,
            serviceRoleArn: this.serviceRole?.roleArn,
            ...extended,
        });
        this.name = supportedName;
        this.api = props.api;
    }
    /**
     * creates a new resolver for this datasource and API using the given properties
     */
    createResolver(id, props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_BaseResolverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.createResolver);
            }
            throw error;
        }
        return new resolver_1.Resolver(this.api, id, {
            api: this.api,
            dataSource: this,
            ...props,
        });
    }
    /**
     * creates a new appsync function for this datasource and API using the given properties
     */
    createFunction(id, props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_BaseAppsyncFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.createFunction);
            }
            throw error;
        }
        return new appsync_function_1.AppsyncFunction(this.api, id, {
            api: this.api,
            dataSource: this,
            ...props,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
BaseDataSource[_a] = { fqn: "aws-cdk-lib.aws_appsync.BaseDataSource", version: "2.74.0" };
exports.BaseDataSource = BaseDataSource;
/**
 * Abstract AppSync datasource implementation. Do not use directly but use subclasses for resource backed datasources
 */
class BackedDataSource extends BaseDataSource {
    constructor(scope, id, props, extended) {
        super(scope, id, props, extended);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_BackedDataSourceProps(props);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_ExtendedDataSourceProps(extended);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BackedDataSource);
            }
            throw error;
        }
        this.grantPrincipal = this.serviceRole;
    }
}
_b = JSII_RTTI_SYMBOL_1;
BackedDataSource[_b] = { fqn: "aws-cdk-lib.aws_appsync.BackedDataSource", version: "2.74.0" };
exports.BackedDataSource = BackedDataSource;
/**
 * An AppSync dummy datasource
 */
class NoneDataSource extends BaseDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'NONE',
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_NoneDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, NoneDataSource);
            }
            throw error;
        }
    }
}
_c = JSII_RTTI_SYMBOL_1;
NoneDataSource[_c] = { fqn: "aws-cdk-lib.aws_appsync.NoneDataSource", version: "2.74.0" };
exports.NoneDataSource = NoneDataSource;
/**
 * An AppSync datasource backed by a DynamoDB table
 */
class DynamoDbDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AMAZON_DYNAMODB',
            dynamoDbConfig: {
                tableName: props.table.tableName,
                awsRegion: props.table.env.region,
                useCallerCredentials: props.useCallerCredentials,
            },
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_DynamoDbDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DynamoDbDataSource);
            }
            throw error;
        }
        if (props.readOnlyAccess) {
            props.table.grantReadData(this);
        }
        else {
            props.table.grantReadWriteData(this);
        }
    }
}
_d = JSII_RTTI_SYMBOL_1;
DynamoDbDataSource[_d] = { fqn: "aws-cdk-lib.aws_appsync.DynamoDbDataSource", version: "2.74.0" };
exports.DynamoDbDataSource = DynamoDbDataSource;
/**
 * An AppSync datasource backed by a http endpoint
 */
class HttpDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_HttpDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpDataSource);
            }
            throw error;
        }
        const authorizationConfig = props.authorizationConfig ? {
            authorizationType: 'AWS_IAM',
            awsIamConfig: props.authorizationConfig,
        } : undefined;
        super(scope, id, props, {
            type: 'HTTP',
            httpConfig: {
                endpoint: props.endpoint,
                authorizationConfig,
            },
        });
    }
}
_e = JSII_RTTI_SYMBOL_1;
HttpDataSource[_e] = { fqn: "aws-cdk-lib.aws_appsync.HttpDataSource", version: "2.74.0" };
exports.HttpDataSource = HttpDataSource;
/**
 * An AppSync datasource backed by a Lambda function
 */
class LambdaDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AWS_LAMBDA',
            lambdaConfig: {
                lambdaFunctionArn: props.lambdaFunction.functionArn,
            },
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_LambdaDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaDataSource);
            }
            throw error;
        }
        props.lambdaFunction.grantInvoke(this);
    }
}
_f = JSII_RTTI_SYMBOL_1;
LambdaDataSource[_f] = { fqn: "aws-cdk-lib.aws_appsync.LambdaDataSource", version: "2.74.0" };
exports.LambdaDataSource = LambdaDataSource;
/**
 * An AppSync datasource backed by RDS
 */
class RdsDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'RELATIONAL_DATABASE',
            relationalDatabaseConfig: {
                rdsHttpEndpointConfig: {
                    awsRegion: props.serverlessCluster.env.region,
                    dbClusterIdentifier: core_1.Lazy.string({
                        produce: () => {
                            return core_1.Stack.of(this).formatArn({
                                service: 'rds',
                                resource: `cluster:${props.serverlessCluster.clusterIdentifier}`,
                            });
                        },
                    }),
                    awsSecretStoreArn: props.secretStore.secretArn,
                    databaseName: props.databaseName,
                },
                relationalDatabaseSourceType: 'RDS_HTTP_ENDPOINT',
            },
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_RdsDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RdsDataSource);
            }
            throw error;
        }
        const clusterArn = core_1.Stack.of(this).formatArn({
            service: 'rds',
            resource: `cluster:${props.serverlessCluster.clusterIdentifier}`,
        });
        props.secretStore.grantRead(this);
        // Change to grant with RDS grant becomes implemented
        props.serverlessCluster.grantDataApiAccess(this);
        aws_iam_1.Grant.addToPrincipal({
            grantee: this,
            actions: [
                'rds-data:DeleteItems',
                'rds-data:ExecuteSql',
                'rds-data:GetItems',
                'rds-data:InsertItems',
                'rds-data:UpdateItems',
            ],
            resourceArns: [clusterArn, `${clusterArn}:*`],
            scope: this,
        });
    }
}
_g = JSII_RTTI_SYMBOL_1;
RdsDataSource[_g] = { fqn: "aws-cdk-lib.aws_appsync.RdsDataSource", version: "2.74.0" };
exports.RdsDataSource = RdsDataSource;
/**
 * An Appsync datasource backed by Elasticsearch
 *
 * @deprecated - use `OpenSearchDataSource`
 */
class ElasticsearchDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AMAZON_ELASTICSEARCH',
            elasticsearchConfig: {
                awsRegion: props.domain.env.region,
                endpoint: `https://${props.domain.domainEndpoint}`,
            },
        });
        try {
            jsiiDeprecationWarnings.print("aws-cdk-lib.aws_appsync.ElasticsearchDataSource", "- use `OpenSearchDataSource`");
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_ElasticsearchDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ElasticsearchDataSource);
            }
            throw error;
        }
        props.domain.grantReadWrite(this);
    }
}
_h = JSII_RTTI_SYMBOL_1;
ElasticsearchDataSource[_h] = { fqn: "aws-cdk-lib.aws_appsync.ElasticsearchDataSource", version: "2.74.0" };
exports.ElasticsearchDataSource = ElasticsearchDataSource;
/**
 * An Appsync datasource backed by OpenSearch
 */
class OpenSearchDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AMAZON_OPENSEARCH_SERVICE',
            openSearchServiceConfig: {
                awsRegion: props.domain.env.region,
                endpoint: `https://${props.domain.domainEndpoint}`,
            },
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_OpenSearchDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, OpenSearchDataSource);
            }
            throw error;
        }
        props.domain.grantReadWrite(this);
    }
}
_j = JSII_RTTI_SYMBOL_1;
OpenSearchDataSource[_j] = { fqn: "aws-cdk-lib.aws_appsync.OpenSearchDataSource", version: "2.74.0" };
exports.OpenSearchDataSource = OpenSearchDataSource;
//# sourceMappingURL=data:application/json;base64,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