"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MappingTemplate = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
/**
 * MappingTemplates for AppSync resolvers
 */
class MappingTemplate {
    /**
     * Create a mapping template from the given string
     */
    static fromString(template) {
        return new StringMappingTemplate(template);
    }
    /**
     * Create a mapping template from the given file
     */
    static fromFile(fileName) {
        return new StringMappingTemplate((0, fs_1.readFileSync)(fileName).toString('utf-8'));
    }
    /**
     * Mapping template for a result list from DynamoDB
     */
    static dynamoDbResultList() {
        return this.fromString('$util.toJson($ctx.result.items)');
    }
    /**
     * Mapping template for a single result item from DynamoDB
     */
    static dynamoDbResultItem() {
        return this.fromString('$util.toJson($ctx.result)');
    }
    /**
     * Mapping template to scan a DynamoDB table to fetch all entries
     */
    static dynamoDbScanTable(consistentRead = false) {
        return this.fromString(`{"version" : "2017-02-28", "operation" : "Scan", "consistentRead": ${consistentRead}}`);
    }
    /**
     * Mapping template to query a set of items from a DynamoDB table
     *
     * @param cond the key condition for the query
     */
    static dynamoDbQuery(cond, indexName, consistentRead = false) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_KeyCondition(cond);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.dynamoDbQuery);
            }
            throw error;
        }
        return this.fromString(`{"version" : "2017-02-28", "operation" : "Query",  "consistentRead": ${consistentRead}, ${indexName ? `"index" : "${indexName}", ` : ''}${cond.renderTemplate()}}`);
    }
    /**
     * Mapping template to get a single item from a DynamoDB table
     *
     * @param keyName the name of the hash key field
     * @param idArg the name of the Query argument
     */
    static dynamoDbGetItem(keyName, idArg, consistentRead = false) {
        return this.fromString(`{"version": "2017-02-28", "operation": "GetItem", "consistentRead": ${consistentRead}, "key": {"${keyName}": $util.dynamodb.toDynamoDBJson($ctx.args.${idArg})}}`);
    }
    /**
     * Mapping template to delete a single item from a DynamoDB table
     *
     * @param keyName the name of the hash key field
     * @param idArg the name of the Mutation argument
     */
    static dynamoDbDeleteItem(keyName, idArg) {
        return this.fromString(`{"version": "2017-02-28", "operation": "DeleteItem", "key": {"${keyName}": $util.dynamodb.toDynamoDBJson($ctx.args.${idArg})}}`);
    }
    /**
     * Mapping template to save a single item to a DynamoDB table
     *
     * @param key the assigment of Mutation values to the primary key
     * @param values the assignment of Mutation values to the table attributes
     */
    static dynamoDbPutItem(key, values) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_PrimaryKey(key);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_AttributeValues(values);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.dynamoDbPutItem);
            }
            throw error;
        }
        return this.fromString(`
      ${values.renderVariables()}
      {
        "version": "2017-02-28",
        "operation": "PutItem",
        ${key.renderTemplate()},
        ${values.renderTemplate()}
      }`);
    }
    /**
     * Mapping template to invoke a Lambda function
     *
     * @param payload the VTL template snippet of the payload to send to the lambda.
     * If no payload is provided all available context fields are sent to the Lambda function
     * @param operation the type of operation AppSync should perform on the data source
     */
    static lambdaRequest(payload = '$util.toJson($ctx)', operation = 'Invoke') {
        return this.fromString(`{"version": "2017-02-28", "operation": "${operation}", "payload": ${payload}}`);
    }
    /**
     * Mapping template to return the Lambda result to the caller
     */
    static lambdaResult() {
        return this.fromString('$util.toJson($ctx.result)');
    }
}
_a = JSII_RTTI_SYMBOL_1;
MappingTemplate[_a] = { fqn: "aws-cdk-lib.aws_appsync.MappingTemplate", version: "2.74.0" };
exports.MappingTemplate = MappingTemplate;
class StringMappingTemplate extends MappingTemplate {
    constructor(template) {
        super();
        this.template = template;
    }
    renderTemplate() {
        return this.template;
    }
}
//# sourceMappingURL=data:application/json;base64,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