"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resolver = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const constructs_1 = require("constructs");
const appsync_generated_1 = require("./appsync.generated");
const caching_key_1 = require("./caching-key");
/**
 * An AppSync resolver
 */
class Resolver extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_ResolverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Resolver);
            }
            throw error;
        }
        const pipelineConfig = props.pipelineConfig && props.pipelineConfig.length ?
            { functions: props.pipelineConfig.map((func) => func.functionId) }
            : undefined;
        // If runtime is specified, code must also be
        if (props.runtime && !props.code) {
            throw new Error('Code is required when specifying a runtime');
        }
        if (props.code && (props.requestMappingTemplate || props.responseMappingTemplate)) {
            throw new Error('Mapping templates cannot be used alongside code');
        }
        if (pipelineConfig && props.dataSource) {
            throw new Error(`Pipeline Resolver cannot have data source. Received: ${props.dataSource.name}`);
        }
        if (props.cachingConfig?.ttl && (props.cachingConfig.ttl.toSeconds() < 1 || props.cachingConfig.ttl.toSeconds() > 3600)) {
            throw new Error(`Caching config TTL must be between 1 and 3600 seconds. Received: ${props.cachingConfig.ttl.toSeconds()}`);
        }
        if (props.cachingConfig?.cachingKeys) {
            if (props.cachingConfig.cachingKeys.find(cachingKey => !core_1.Token.isUnresolved(cachingKey) && !caching_key_1.BASE_CACHING_KEYS.find(baseCachingKey => cachingKey.startsWith(baseCachingKey)))) {
                throw new Error(`Caching config keys must begin with $context.arguments, $context.source or $context.identity. Received: ${props.cachingConfig.cachingKeys}`);
            }
        }
        const code = props.code?.bind(this);
        this.resolver = new appsync_generated_1.CfnResolver(this, 'Resource', {
            apiId: props.api.apiId,
            typeName: props.typeName,
            fieldName: props.fieldName,
            dataSourceName: props.dataSource ? props.dataSource.name : undefined,
            kind: pipelineConfig ? 'PIPELINE' : 'UNIT',
            runtime: props.runtime?.toProperties(),
            codeS3Location: code?.s3Location,
            code: code?.inlineCode,
            pipelineConfig: pipelineConfig,
            requestMappingTemplate: props.requestMappingTemplate ? props.requestMappingTemplate.renderTemplate() : undefined,
            responseMappingTemplate: props.responseMappingTemplate ? props.responseMappingTemplate.renderTemplate() : undefined,
            cachingConfig: this.createCachingConfig(props.cachingConfig),
            maxBatchSize: props.maxBatchSize,
        });
        props.api.addSchemaDependency(this.resolver);
        if (props.dataSource) {
            this.resolver.addDependency(props.dataSource.ds);
        }
        this.arn = this.resolver.attrResolverArn;
    }
    createCachingConfig(config) {
        return config ? {
            cachingKeys: config.cachingKeys,
            ttl: config.ttl?.toSeconds(),
        } : undefined;
    }
}
_a = JSII_RTTI_SYMBOL_1;
Resolver[_a] = { fqn: "aws-cdk-lib.aws_appsync.Resolver", version: "2.74.0" };
exports.Resolver = Resolver;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVzb2x2ZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJyZXNvbHZlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxxQ0FBbUM7QUFDbkMsMkNBQXVDO0FBRXZDLDJEQUFrRDtBQUVsRCwrQ0FBa0Q7QUF1RmxEOztHQUVHO0FBQ0gsTUFBYSxRQUFTLFNBQVEsc0JBQVM7SUFRckMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFvQjtRQUM1RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7K0NBVFIsUUFBUTs7OztRQVdqQixNQUFNLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxJQUFJLEtBQUssQ0FBQyxjQUFjLENBQUMsTUFBTSxDQUFDLENBQUM7WUFDMUUsRUFBRSxTQUFTLEVBQUUsS0FBSyxDQUFDLGNBQWMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRTtZQUNsRSxDQUFDLENBQUMsU0FBUyxDQUFDO1FBRWQsNkNBQTZDO1FBQzdDLElBQUksS0FBSyxDQUFDLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUU7WUFDaEMsTUFBTSxJQUFJLEtBQUssQ0FBQyw0Q0FBNEMsQ0FBQyxDQUFDO1NBQy9EO1FBRUQsSUFBSSxLQUFLLENBQUMsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLHNCQUFzQixJQUFJLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQyxFQUFFO1lBQ2pGLE1BQU0sSUFBSSxLQUFLLENBQUMsaURBQWlELENBQUMsQ0FBQztTQUNwRTtRQUVELElBQUksY0FBYyxJQUFJLEtBQUssQ0FBQyxVQUFVLEVBQUU7WUFDdEMsTUFBTSxJQUFJLEtBQUssQ0FBQyx3REFBd0QsS0FBSyxDQUFDLFVBQVUsQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDO1NBQ2xHO1FBRUQsSUFBSSxLQUFLLENBQUMsYUFBYSxFQUFFLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsSUFBSSxLQUFLLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxTQUFTLEVBQUUsR0FBRyxJQUFJLENBQUMsRUFBRTtZQUN2SCxNQUFNLElBQUksS0FBSyxDQUFDLG9FQUFvRSxLQUFLLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxTQUFTLEVBQUUsRUFBRSxDQUFDLENBQUM7U0FDNUg7UUFFRCxJQUFJLEtBQUssQ0FBQyxhQUFhLEVBQUUsV0FBVyxFQUFFO1lBQ3BDLElBQUksS0FBSyxDQUFDLGFBQWEsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxFQUFFLENBQ3BELENBQUMsWUFBSyxDQUFDLFlBQVksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLCtCQUFpQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxFQUFFO2dCQUN0SCxNQUFNLElBQUksS0FBSyxDQUFDLDJHQUEyRyxLQUFLLENBQUMsYUFBYSxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUM7YUFDL0o7U0FDRjtRQUVELE1BQU0sSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSwrQkFBVyxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDaEQsS0FBSyxFQUFFLEtBQUssQ0FBQyxHQUFHLENBQUMsS0FBSztZQUN0QixRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLGNBQWMsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUztZQUNwRSxJQUFJLEVBQUUsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLE1BQU07WUFDMUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPLEVBQUUsWUFBWSxFQUFFO1lBQ3RDLGNBQWMsRUFBRSxJQUFJLEVBQUUsVUFBVTtZQUNoQyxJQUFJLEVBQUUsSUFBSSxFQUFFLFVBQVU7WUFDdEIsY0FBYyxFQUFFLGNBQWM7WUFDOUIsc0JBQXNCLEVBQUUsS0FBSyxDQUFDLHNCQUFzQixDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsc0JBQXNCLENBQUMsY0FBYyxFQUFFLENBQUMsQ0FBQyxDQUFDLFNBQVM7WUFDaEgsdUJBQXVCLEVBQUUsS0FBSyxDQUFDLHVCQUF1QixDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsdUJBQXVCLENBQUMsY0FBYyxFQUFFLENBQUMsQ0FBQyxDQUFDLFNBQVM7WUFDbkgsYUFBYSxFQUFFLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDO1lBQzVELFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtTQUNqQyxDQUFDLENBQUM7UUFDSCxLQUFLLENBQUMsR0FBRyxDQUFDLG1CQUFtQixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUM3QyxJQUFJLEtBQUssQ0FBQyxVQUFVLEVBQUU7WUFDcEIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxFQUFFLENBQUMsQ0FBQztTQUNsRDtRQUNELElBQUksQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxlQUFlLENBQUM7S0FDMUM7SUFFTyxtQkFBbUIsQ0FBQyxNQUFzQjtRQUNoRCxPQUFPLE1BQU0sQ0FBQyxDQUFDLENBQUM7WUFDZCxXQUFXLEVBQUUsTUFBTSxDQUFDLFdBQVc7WUFDL0IsR0FBRyxFQUFFLE1BQU0sQ0FBQyxHQUFHLEVBQUUsU0FBUyxFQUFFO1NBQzdCLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztLQUNmOzs7O0FBbkVVLDRCQUFRIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVG9rZW4gfSBmcm9tICcuLi8uLi9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSUFwcHN5bmNGdW5jdGlvbiB9IGZyb20gJy4vYXBwc3luYy1mdW5jdGlvbic7XG5pbXBvcnQgeyBDZm5SZXNvbHZlciB9IGZyb20gJy4vYXBwc3luYy5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgQ2FjaGluZ0NvbmZpZyB9IGZyb20gJy4vY2FjaGluZy1jb25maWcnO1xuaW1wb3J0IHsgQkFTRV9DQUNISU5HX0tFWVMgfSBmcm9tICcuL2NhY2hpbmcta2V5JztcbmltcG9ydCB7IENvZGUgfSBmcm9tICcuL2NvZGUnO1xuaW1wb3J0IHsgQmFzZURhdGFTb3VyY2UgfSBmcm9tICcuL2RhdGEtc291cmNlJztcbmltcG9ydCB7IElHcmFwaHFsQXBpIH0gZnJvbSAnLi9ncmFwaHFsYXBpLWJhc2UnO1xuaW1wb3J0IHsgTWFwcGluZ1RlbXBsYXRlIH0gZnJvbSAnLi9tYXBwaW5nLXRlbXBsYXRlJztcbmltcG9ydCB7IEZ1bmN0aW9uUnVudGltZSB9IGZyb20gJy4vcnVudGltZSc7XG5cbi8qKlxuICogQmFzaWMgcHJvcGVydGllcyBmb3IgYW4gQXBwU3luYyByZXNvbHZlclxuICovXG5leHBvcnQgaW50ZXJmYWNlIEJhc2VSZXNvbHZlclByb3BzIHtcbiAgLyoqXG4gICAqIG5hbWUgb2YgdGhlIEdyYXBoUUwgdHlwZSB0aGlzIHJlc29sdmVyIGlzIGF0dGFjaGVkIHRvXG4gICAqL1xuICByZWFkb25seSB0eXBlTmFtZTogc3RyaW5nO1xuICAvKipcbiAgICogbmFtZSBvZiB0aGUgR3JhcGhRTCBmaWVsZCBpbiB0aGUgZ2l2ZW4gdHlwZSB0aGlzIHJlc29sdmVyIGlzIGF0dGFjaGVkIHRvXG4gICAqL1xuICByZWFkb25seSBmaWVsZE5hbWU6IHN0cmluZztcbiAgLyoqXG4gICAqIGNvbmZpZ3VyYXRpb24gb2YgdGhlIHBpcGVsaW5lIHJlc29sdmVyXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gcGlwZWxpbmUgcmVzb2x2ZXIgY29uZmlndXJhdGlvblxuICAgKiBBbiBlbXB0eSBhcnJheSB8IHVuZGVmaW5lZCBzZXRzIHJlc29sdmVyIHRvIGJlIG9mIGtpbmQsIHVuaXRcbiAgICovXG4gIHJlYWRvbmx5IHBpcGVsaW5lQ29uZmlnPzogSUFwcHN5bmNGdW5jdGlvbltdO1xuICAvKipcbiAgICogVGhlIHJlcXVlc3QgbWFwcGluZyB0ZW1wbGF0ZSBmb3IgdGhpcyByZXNvbHZlclxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIG1hcHBpbmcgdGVtcGxhdGVcbiAgICovXG4gIHJlYWRvbmx5IHJlcXVlc3RNYXBwaW5nVGVtcGxhdGU/OiBNYXBwaW5nVGVtcGxhdGU7XG4gIC8qKlxuICAgKiBUaGUgcmVzcG9uc2UgbWFwcGluZyB0ZW1wbGF0ZSBmb3IgdGhpcyByZXNvbHZlclxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIG1hcHBpbmcgdGVtcGxhdGVcbiAgICovXG4gIHJlYWRvbmx5IHJlc3BvbnNlTWFwcGluZ1RlbXBsYXRlPzogTWFwcGluZ1RlbXBsYXRlO1xuICAvKipcbiAgICogVGhlIGNhY2hpbmcgY29uZmlndXJhdGlvbiBmb3IgdGhpcyByZXNvbHZlclxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIGNhY2hpbmcgY29uZmlndXJhdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgY2FjaGluZ0NvbmZpZz86IENhY2hpbmdDb25maWc7XG4gIC8qKlxuICAgKiBUaGUgbWF4aW11bSBudW1iZXIgb2YgZWxlbWVudHMgcGVyIGJhdGNoLCB3aGVuIHVzaW5nIGJhdGNoIGludm9rZVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIG1heCBiYXRjaCBzaXplXG4gICAqL1xuICByZWFkb25seSBtYXhCYXRjaFNpemU/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBmdW5jdGlvbnMgcnVudGltZVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGZ1bmN0aW9uIHJ1bnRpbWUsIFZUTCBtYXBwaW5nIHRlbXBsYXRlcyB1c2VkXG4gICAqL1xuICByZWFkb25seSBydW50aW1lPzogRnVuY3Rpb25SdW50aW1lO1xuICAvKipcbiAgICogVGhlIGZ1bmN0aW9uIGNvZGVcbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBjb2RlIGlzIHVzZWRcbiAgICovXG4gIHJlYWRvbmx5IGNvZGU/OiBDb2RlO1xufVxuXG4vKipcbiAqIEFkZGl0aW9uYWwgcHJvcGVydHkgZm9yIGFuIEFwcFN5bmMgcmVzb2x2ZXIgZm9yIGRhdGEgc291cmNlIHJlZmVyZW5jZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIEV4dGVuZGVkUmVzb2x2ZXJQcm9wcyBleHRlbmRzIEJhc2VSZXNvbHZlclByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBkYXRhIHNvdXJjZSB0aGlzIHJlc29sdmVyIGlzIHVzaW5nXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gZGF0YXNvdXJjZVxuICAgKi9cbiAgcmVhZG9ubHkgZGF0YVNvdXJjZT86IEJhc2VEYXRhU291cmNlO1xufVxuXG4vKipcbiAqIEFkZGl0aW9uYWwgcHJvcGVydHkgZm9yIGFuIEFwcFN5bmMgcmVzb2x2ZXIgZm9yIEdyYXBoUUwgQVBJIHJlZmVyZW5jZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIFJlc29sdmVyUHJvcHMgZXh0ZW5kcyBFeHRlbmRlZFJlc29sdmVyUHJvcHMge1xuICAvKipcbiAgICogVGhlIEFQSSB0aGlzIHJlc29sdmVyIGlzIGF0dGFjaGVkIHRvXG4gICAqL1xuICByZWFkb25seSBhcGk6IElHcmFwaHFsQXBpO1xufVxuXG4vKipcbiAqIEFuIEFwcFN5bmMgcmVzb2x2ZXJcbiAqL1xuZXhwb3J0IGNsYXNzIFJlc29sdmVyIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgLyoqXG4gICAqIHRoZSBBUk4gb2YgdGhlIHJlc29sdmVyXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgYXJuOiBzdHJpbmc7XG5cbiAgcHJpdmF0ZSByZXNvbHZlcjogQ2ZuUmVzb2x2ZXI7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFJlc29sdmVyUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgcGlwZWxpbmVDb25maWcgPSBwcm9wcy5waXBlbGluZUNvbmZpZyAmJiBwcm9wcy5waXBlbGluZUNvbmZpZy5sZW5ndGggP1xuICAgICAgeyBmdW5jdGlvbnM6IHByb3BzLnBpcGVsaW5lQ29uZmlnLm1hcCgoZnVuYykgPT4gZnVuYy5mdW5jdGlvbklkKSB9XG4gICAgICA6IHVuZGVmaW5lZDtcblxuICAgIC8vIElmIHJ1bnRpbWUgaXMgc3BlY2lmaWVkLCBjb2RlIG11c3QgYWxzbyBiZVxuICAgIGlmIChwcm9wcy5ydW50aW1lICYmICFwcm9wcy5jb2RlKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0NvZGUgaXMgcmVxdWlyZWQgd2hlbiBzcGVjaWZ5aW5nIGEgcnVudGltZScpO1xuICAgIH1cblxuICAgIGlmIChwcm9wcy5jb2RlICYmIChwcm9wcy5yZXF1ZXN0TWFwcGluZ1RlbXBsYXRlIHx8IHByb3BzLnJlc3BvbnNlTWFwcGluZ1RlbXBsYXRlKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdNYXBwaW5nIHRlbXBsYXRlcyBjYW5ub3QgYmUgdXNlZCBhbG9uZ3NpZGUgY29kZScpO1xuICAgIH1cblxuICAgIGlmIChwaXBlbGluZUNvbmZpZyAmJiBwcm9wcy5kYXRhU291cmNlKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYFBpcGVsaW5lIFJlc29sdmVyIGNhbm5vdCBoYXZlIGRhdGEgc291cmNlLiBSZWNlaXZlZDogJHtwcm9wcy5kYXRhU291cmNlLm5hbWV9YCk7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLmNhY2hpbmdDb25maWc/LnR0bCAmJiAocHJvcHMuY2FjaGluZ0NvbmZpZy50dGwudG9TZWNvbmRzKCkgPCAxIHx8IHByb3BzLmNhY2hpbmdDb25maWcudHRsLnRvU2Vjb25kcygpID4gMzYwMCkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgQ2FjaGluZyBjb25maWcgVFRMIG11c3QgYmUgYmV0d2VlbiAxIGFuZCAzNjAwIHNlY29uZHMuIFJlY2VpdmVkOiAke3Byb3BzLmNhY2hpbmdDb25maWcudHRsLnRvU2Vjb25kcygpfWApO1xuICAgIH1cblxuICAgIGlmIChwcm9wcy5jYWNoaW5nQ29uZmlnPy5jYWNoaW5nS2V5cykge1xuICAgICAgaWYgKHByb3BzLmNhY2hpbmdDb25maWcuY2FjaGluZ0tleXMuZmluZChjYWNoaW5nS2V5ID0+XG4gICAgICAgICFUb2tlbi5pc1VucmVzb2x2ZWQoY2FjaGluZ0tleSkgJiYgIUJBU0VfQ0FDSElOR19LRVlTLmZpbmQoYmFzZUNhY2hpbmdLZXkgPT4gY2FjaGluZ0tleS5zdGFydHNXaXRoKGJhc2VDYWNoaW5nS2V5KSkpKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihgQ2FjaGluZyBjb25maWcga2V5cyBtdXN0IGJlZ2luIHdpdGggJGNvbnRleHQuYXJndW1lbnRzLCAkY29udGV4dC5zb3VyY2Ugb3IgJGNvbnRleHQuaWRlbnRpdHkuIFJlY2VpdmVkOiAke3Byb3BzLmNhY2hpbmdDb25maWcuY2FjaGluZ0tleXN9YCk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgY29uc3QgY29kZSA9IHByb3BzLmNvZGU/LmJpbmQodGhpcyk7XG4gICAgdGhpcy5yZXNvbHZlciA9IG5ldyBDZm5SZXNvbHZlcih0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBhcGlJZDogcHJvcHMuYXBpLmFwaUlkLFxuICAgICAgdHlwZU5hbWU6IHByb3BzLnR5cGVOYW1lLFxuICAgICAgZmllbGROYW1lOiBwcm9wcy5maWVsZE5hbWUsXG4gICAgICBkYXRhU291cmNlTmFtZTogcHJvcHMuZGF0YVNvdXJjZSA/IHByb3BzLmRhdGFTb3VyY2UubmFtZSA6IHVuZGVmaW5lZCxcbiAgICAgIGtpbmQ6IHBpcGVsaW5lQ29uZmlnID8gJ1BJUEVMSU5FJyA6ICdVTklUJyxcbiAgICAgIHJ1bnRpbWU6IHByb3BzLnJ1bnRpbWU/LnRvUHJvcGVydGllcygpLFxuICAgICAgY29kZVMzTG9jYXRpb246IGNvZGU/LnMzTG9jYXRpb24sXG4gICAgICBjb2RlOiBjb2RlPy5pbmxpbmVDb2RlLFxuICAgICAgcGlwZWxpbmVDb25maWc6IHBpcGVsaW5lQ29uZmlnLFxuICAgICAgcmVxdWVzdE1hcHBpbmdUZW1wbGF0ZTogcHJvcHMucmVxdWVzdE1hcHBpbmdUZW1wbGF0ZSA/IHByb3BzLnJlcXVlc3RNYXBwaW5nVGVtcGxhdGUucmVuZGVyVGVtcGxhdGUoKSA6IHVuZGVmaW5lZCxcbiAgICAgIHJlc3BvbnNlTWFwcGluZ1RlbXBsYXRlOiBwcm9wcy5yZXNwb25zZU1hcHBpbmdUZW1wbGF0ZSA/IHByb3BzLnJlc3BvbnNlTWFwcGluZ1RlbXBsYXRlLnJlbmRlclRlbXBsYXRlKCkgOiB1bmRlZmluZWQsXG4gICAgICBjYWNoaW5nQ29uZmlnOiB0aGlzLmNyZWF0ZUNhY2hpbmdDb25maWcocHJvcHMuY2FjaGluZ0NvbmZpZyksXG4gICAgICBtYXhCYXRjaFNpemU6IHByb3BzLm1heEJhdGNoU2l6ZSxcbiAgICB9KTtcbiAgICBwcm9wcy5hcGkuYWRkU2NoZW1hRGVwZW5kZW5jeSh0aGlzLnJlc29sdmVyKTtcbiAgICBpZiAocHJvcHMuZGF0YVNvdXJjZSkge1xuICAgICAgdGhpcy5yZXNvbHZlci5hZGREZXBlbmRlbmN5KHByb3BzLmRhdGFTb3VyY2UuZHMpO1xuICAgIH1cbiAgICB0aGlzLmFybiA9IHRoaXMucmVzb2x2ZXIuYXR0clJlc29sdmVyQXJuO1xuICB9XG5cbiAgcHJpdmF0ZSBjcmVhdGVDYWNoaW5nQ29uZmlnKGNvbmZpZz86IENhY2hpbmdDb25maWcpIHtcbiAgICByZXR1cm4gY29uZmlnID8ge1xuICAgICAgY2FjaGluZ0tleXM6IGNvbmZpZy5jYWNoaW5nS2V5cyxcbiAgICAgIHR0bDogY29uZmlnLnR0bD8udG9TZWNvbmRzKCksXG4gICAgfSA6IHVuZGVmaW5lZDtcbiAgfVxuXG59XG4iXX0=