"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionRuntime = exports.FunctionRuntimeFamily = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Appsync supported runtimes. Only JavaScript as of now
 */
var FunctionRuntimeFamily;
(function (FunctionRuntimeFamily) {
    /**
     * AppSync JavaScript runtime
     */
    FunctionRuntimeFamily["JS"] = "APPSYNC_JS";
})(FunctionRuntimeFamily = exports.FunctionRuntimeFamily || (exports.FunctionRuntimeFamily = {}));
/**
 * Utility class for specifying specific appsync runtime versions
 */
class FunctionRuntime {
    constructor(family, version) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_FunctionRuntimeFamily(family);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FunctionRuntime);
            }
            throw error;
        }
        this.name = family;
        this.version = version;
    }
    /**
     * Convert to Cfn runtime configuration property format
     */
    toProperties() {
        return {
            name: this.name,
            runtimeVersion: this.version,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
FunctionRuntime[_a] = { fqn: "aws-cdk-lib.aws_appsync.FunctionRuntime", version: "2.74.0" };
/**
 * APPSYNC_JS v1.0.0 runtime
 */
FunctionRuntime.JS_1_0_0 = new FunctionRuntime(FunctionRuntimeFamily.JS, '1.0.0');
exports.FunctionRuntime = FunctionRuntime;
//# sourceMappingURL=data:application/json;base64,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