"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SchemaFile = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
;
/**
 * The Schema for a GraphQL Api
 *
 * If no options are configured, schema will be generated
 * code-first.
 */
class SchemaFile {
    /**
     * Generate a Schema from file
     *
     * @returns `SchemaAsset` with immutable schema defintion
     * @param filePath the file path of the schema file
     */
    static fromAsset(filePath) {
        return new SchemaFile({ filePath });
    }
    constructor(options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_SchemaProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SchemaFile);
            }
            throw error;
        }
        this.definition = (0, fs_1.readFileSync)(options.filePath).toString('utf-8');
    }
    /**
     * Called when the GraphQL Api is initialized to allow this object to bind
     * to the stack.
     *
     * @param api The binding GraphQL Api
     */
    bind(api, _options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_IGraphqlApi(api);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_SchemaBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            apiId: api.apiId,
            definition: this.definition,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
SchemaFile[_a] = { fqn: "aws-cdk-lib.aws_appsync.SchemaFile", version: "2.74.0" };
exports.SchemaFile = SchemaFile;
//# sourceMappingURL=data:application/json;base64,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