"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionHook = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sns = require("../../aws-sns");
const subs = require("../../aws-sns-subscriptions");
const common_1 = require("./common");
const topic_hook_1 = require("./topic-hook");
/**
 * Use a Lambda Function as a hook target
 *
 * Internally creates a Topic to make the connection.
 */
class FunctionHook {
    /**
     * @param fn Function to invoke in response to a lifecycle event
     * @param encryptionKey If provided, this key is used to encrypt the contents of the SNS topic.
     */
    constructor(fn, encryptionKey) {
        this.fn = fn;
        this.encryptionKey = encryptionKey;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(fn);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_kms_IKey(encryptionKey);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FunctionHook);
            }
            throw error;
        }
    }
    /**
     * If the `IRole` does not exist in `options`, will create an `IRole` and an SNS Topic and attach both to the lifecycle hook.
     * If the `IRole` does exist in `options`, will only create an SNS Topic and attach it to the lifecycle hook.
     */
    bind(_scope, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_autoscaling_BindHookTargetOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const topic = new sns.Topic(_scope, 'Topic', {
            masterKey: this.encryptionKey,
        });
        const role = (0, common_1.createRole)(_scope, options.role);
        // Per: https://docs.aws.amazon.com/sns/latest/dg/sns-key-management.html#sns-what-permissions-for-sse
        // Topic's grantPublish() is in a base class that does not know there is a kms key, and so does not
        // grant appropriate permissions to the kms key. We do that here to ensure the correct permissions
        // are in place.
        this.encryptionKey?.grant(role, 'kms:Decrypt', 'kms:GenerateDataKey');
        topic.addSubscription(new subs.LambdaSubscription(this.fn));
        return new topic_hook_1.TopicHook(topic).bind(_scope, { lifecycleHook: options.lifecycleHook, role });
    }
}
_a = JSII_RTTI_SYMBOL_1;
FunctionHook[_a] = { fqn: "aws-cdk-lib.aws_autoscaling_hooktargets.FunctionHook", version: "2.74.0" };
exports.FunctionHook = FunctionHook;
//# sourceMappingURL=data:application/json;base64,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