"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScalingGroupRequireImdsv2Aspect = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../../core");
const auto_scaling_group_1 = require("../auto-scaling-group");
/**
 * Aspect that makes IMDSv2 required on instances deployed by AutoScalingGroups.
 */
class AutoScalingGroupRequireImdsv2Aspect {
    constructor() {
    }
    visit(node) {
        if (!(node instanceof auto_scaling_group_1.AutoScalingGroup)) {
            return;
        }
        const launchConfig = node.node.tryFindChild('LaunchConfig');
        if (cdk.isResolvableObject(launchConfig.metadataOptions)) {
            this.warn(node, 'CfnLaunchConfiguration.MetadataOptions field is a CDK token.');
            return;
        }
        launchConfig.metadataOptions = {
            ...launchConfig.metadataOptions,
            httpTokens: 'required',
        };
    }
    /**
     * Adds a warning annotation to a node.
     *
     * @param node The scope to add the warning to.
     * @param message The warning message.
     */
    warn(node, message) {
        cdk.Annotations.of(node).addWarning(`${AutoScalingGroupRequireImdsv2Aspect.name} failed on node ${node.node.id}: ${message}`);
    }
}
_a = JSII_RTTI_SYMBOL_1;
AutoScalingGroupRequireImdsv2Aspect[_a] = { fqn: "aws-cdk-lib.aws_autoscaling.AutoScalingGroupRequireImdsv2Aspect", version: "2.74.0" };
exports.AutoScalingGroupRequireImdsv2Aspect = AutoScalingGroupRequireImdsv2Aspect;
//# sourceMappingURL=data:application/json;base64,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