"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduledAction = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const autoscaling_generated_1 = require("./autoscaling.generated");
/**
 * Define a scheduled scaling action
 */
class ScheduledAction extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_autoscaling_ScheduledActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ScheduledAction);
            }
            throw error;
        }
        if (props.minCapacity === undefined && props.maxCapacity === undefined && props.desiredCapacity === undefined) {
            throw new Error('At least one of minCapacity, maxCapacity, or desiredCapacity is required');
        }
        // add a warning on synth when minute is not defined in a cron schedule
        props.schedule._bind(this);
        const resource = new autoscaling_generated_1.CfnScheduledAction(this, 'Resource', {
            autoScalingGroupName: props.autoScalingGroup.autoScalingGroupName,
            startTime: formatISO(props.startTime),
            endTime: formatISO(props.endTime),
            minSize: props.minCapacity,
            maxSize: props.maxCapacity,
            desiredCapacity: props.desiredCapacity,
            recurrence: props.schedule.expressionString,
            timeZone: props.timeZone,
        });
        this.scheduledActionName = resource.attrScheduledActionName;
    }
}
_a = JSII_RTTI_SYMBOL_1;
ScheduledAction[_a] = { fqn: "aws-cdk-lib.aws_autoscaling.ScheduledAction", version: "2.74.0" };
exports.ScheduledAction = ScheduledAction;
function formatISO(date) {
    if (!date) {
        return undefined;
    }
    return date.getUTCFullYear() +
        '-' + pad(date.getUTCMonth() + 1) +
        '-' + pad(date.getUTCDate()) +
        'T' + pad(date.getUTCHours()) +
        ':' + pad(date.getUTCMinutes()) +
        ':' + pad(date.getUTCSeconds()) +
        'Z';
    function pad(num) {
        if (num < 10) {
            return '0' + num;
        }
        return num;
    }
}
//# sourceMappingURL=data:application/json;base64,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