"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PoolState = exports.WarmPool = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const autoscaling_generated_1 = require("./autoscaling.generated");
/**
 * Define a warm pool
 */
class WarmPool extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: core_1.Lazy.string({ produce: () => core_1.Names.uniqueId(this) }),
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_autoscaling_WarmPoolProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WarmPool);
            }
            throw error;
        }
        if (props.maxGroupPreparedCapacity && props.maxGroupPreparedCapacity < -1) {
            throw new Error('\'maxGroupPreparedCapacity\' parameter should be greater than or equal to -1');
        }
        if (props.minSize && props.minSize < 0) {
            throw new Error('\'minSize\' parameter should be greater than or equal to 0');
        }
        new autoscaling_generated_1.CfnWarmPool(this, 'Resource', {
            autoScalingGroupName: props.autoScalingGroup.autoScalingGroupName,
            instanceReusePolicy: props.reuseOnScaleIn !== undefined ? {
                reuseOnScaleIn: props.reuseOnScaleIn,
            } : undefined,
            maxGroupPreparedCapacity: props.maxGroupPreparedCapacity,
            minSize: props.minSize,
            poolState: props.poolState,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
WarmPool[_a] = { fqn: "aws-cdk-lib.aws_autoscaling.WarmPool", version: "2.74.0" };
exports.WarmPool = WarmPool;
/**
 * The instance state in the warm pool
 */
var PoolState;
(function (PoolState) {
    /**
     * Hibernated
     *
     * To use this state, prerequisites must be in place.
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html
     */
    PoolState["HIBERNATED"] = "Hibernated";
    /**
     * Running
     */
    PoolState["RUNNING"] = "Running";
    /**
     * Stopped
     */
    PoolState["STOPPED"] = "Stopped";
})(PoolState = exports.PoolState || (exports.PoolState = {}));
//# sourceMappingURL=data:application/json;base64,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