"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupableResourcesCollector = void 0;
const dynamodb = require("../../aws-dynamodb");
const ec2 = require("../../aws-ec2");
const efs = require("../../aws-efs");
const rds = require("../../aws-rds");
const core_1 = require("../../core");
class BackupableResourcesCollector {
    constructor() {
        this.resources = [];
    }
    visit(node) {
        if (node instanceof efs.CfnFileSystem) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'elasticfilesystem',
                resource: 'file-system',
                resourceName: node.ref,
            }));
        }
        if (node instanceof dynamodb.CfnTable) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'dynamodb',
                resource: 'table',
                resourceName: node.ref,
            }));
        }
        if (node instanceof ec2.CfnInstance) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'ec2',
                resource: 'instance',
                resourceName: node.ref,
            }));
        }
        if (node instanceof ec2.CfnVolume) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'ec2',
                resource: 'volume',
                resourceName: node.ref,
            }));
        }
        if (node instanceof rds.CfnDBInstance) {
            const dbInstance = node;
            if (!dbInstance.dbClusterIdentifier) {
                this.resources.push(core_1.Stack.of(node).formatArn({
                    service: 'rds',
                    resource: 'db',
                    arnFormat: core_1.ArnFormat.COLON_RESOURCE_NAME,
                    resourceName: node.ref,
                }));
            }
        }
        if (node instanceof rds.CfnDBCluster) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'rds',
                resource: 'cluster',
                arnFormat: core_1.ArnFormat.COLON_RESOURCE_NAME,
                resourceName: node.ref,
            }));
        }
    }
}
exports.BackupableResourcesCollector = BackupableResourcesCollector;
//# sourceMappingURL=data:application/json;base64,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