"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupResource = exports.TagOperation = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
/**
 * An operation that is applied to a key-value pair
 */
var TagOperation;
(function (TagOperation) {
    /**
     * StringEquals
     */
    TagOperation["STRING_EQUALS"] = "STRINGEQUALS";
    /**
     * Dummy member
     */
    TagOperation["DUMMY"] = "dummy";
})(TagOperation = exports.TagOperation || (exports.TagOperation = {}));
/**
 * A resource to backup
 */
class BackupResource {
    /**
     * Adds all supported resources in a construct
     *
     * @param construct The construct containing resources to backup
     */
    static fromConstruct(construct) {
        return new BackupResource(undefined, undefined, construct);
    }
    /**
     * A DynamoDB table
     */
    static fromDynamoDbTable(table) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_dynamodb_ITable(table);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromDynamoDbTable);
            }
            throw error;
        }
        return BackupResource.fromArn(table.tableArn);
    }
    /**
     * An EC2 instance
     */
    static fromEc2Instance(instance) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_IInstance(instance);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEc2Instance);
            }
            throw error;
        }
        return BackupResource.fromArn(core_1.Stack.of(instance).formatArn({
            service: 'ec2',
            resource: 'instance',
            resourceName: instance.instanceId,
        }));
    }
    /**
     * An EFS file system
     */
    static fromEfsFileSystem(fileSystem) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_efs_IFileSystem(fileSystem);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEfsFileSystem);
            }
            throw error;
        }
        return BackupResource.fromArn(core_1.Stack.of(fileSystem).formatArn({
            service: 'elasticfilesystem',
            resource: 'file-system',
            resourceName: fileSystem.fileSystemId,
        }));
    }
    /**
     * A RDS database instance
     */
    static fromRdsDatabaseInstance(instance) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_IDatabaseInstance(instance);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromRdsDatabaseInstance);
            }
            throw error;
        }
        return BackupResource.fromArn(instance.instanceArn);
    }
    /**
     * A RDS database cluter
     */
    static fromRdsDatabaseCluster(cluster) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_IDatabaseCluster(cluster);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromRdsDatabaseCluster);
            }
            throw error;
        }
        const stack = core_1.Stack.of(cluster);
        return BackupResource.fromArn(`arn:${stack.partition}:rds:${stack.region}:${stack.account}:cluster:${cluster.clusterIdentifier}`);
    }
    /**
     * An Aurora database instance
     */
    static fromRdsServerlessCluster(cluster) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_IServerlessCluster(cluster);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromRdsServerlessCluster);
            }
            throw error;
        }
        return BackupResource.fromArn(cluster.clusterArn);
    }
    /**
     * A list of ARNs or match patterns such as
     * `arn:aws:ec2:us-east-1:123456789012:volume/*`
     */
    static fromArn(arn) {
        return new BackupResource(arn);
    }
    /**
     * A tag condition
     */
    static fromTag(key, value, operation) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_backup_TagOperation(operation);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromTag);
            }
            throw error;
        }
        return new BackupResource(undefined, {
            key,
            value,
            operation,
        });
    }
    constructor(resource, tagCondition, construct) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_backup_TagCondition(tagCondition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BackupResource);
            }
            throw error;
        }
        this.resource = resource;
        this.tagCondition = tagCondition;
        this.construct = construct;
    }
}
_a = JSII_RTTI_SYMBOL_1;
BackupResource[_a] = { fqn: "aws-cdk-lib.aws_backup.BackupResource", version: "2.74.0" };
exports.BackupResource = BackupResource;
//# sourceMappingURL=data:application/json;base64,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