"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupSelection = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const core_1 = require("../../core");
const backup_generated_1 = require("./backup.generated");
const backupable_resources_collector_1 = require("./backupable-resources-collector");
const resource_1 = require("./resource");
/**
 * A backup selection
 */
class BackupSelection extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.listOfTags = [];
        this.resources = [];
        this.backupableResourcesCollector = new backupable_resources_collector_1.BackupableResourcesCollector();
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_backup_BackupSelectionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BackupSelection);
            }
            throw error;
        }
        const role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('backup.amazonaws.com'),
        });
        role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSBackupServiceRolePolicyForBackup'));
        if (props.allowRestores) {
            role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSBackupServiceRolePolicyForRestores'));
        }
        this.grantPrincipal = role;
        const selection = new backup_generated_1.CfnBackupSelection(this, 'Resource', {
            backupPlanId: props.backupPlan.backupPlanId,
            backupSelection: {
                iamRoleArn: role.roleArn,
                selectionName: props.backupSelectionName || this.node.id,
                listOfTags: core_1.Lazy.any({
                    produce: () => this.listOfTags,
                }, { omitEmptyArray: true }),
                resources: core_1.Lazy.list({
                    produce: () => [...this.resources, ...this.backupableResourcesCollector.resources],
                }, { omitEmpty: true }),
            },
        });
        this.backupPlanId = selection.attrBackupPlanId;
        this.selectionId = selection.attrSelectionId;
        for (const resource of props.resources) {
            this.addResource(resource);
        }
    }
    addResource(resource) {
        if (resource.tagCondition) {
            this.listOfTags.push({
                conditionKey: resource.tagCondition.key,
                conditionType: resource.tagCondition.operation || resource_1.TagOperation.STRING_EQUALS,
                conditionValue: resource.tagCondition.value,
            });
        }
        if (resource.resource) {
            this.resources.push(resource.resource);
        }
        if (resource.construct) {
            core_1.Aspects.of(resource.construct).add(this.backupableResourcesCollector);
            // Cannot push `this.backupableResourcesCollector.resources` to
            // `this.resources` here because it has not been evaluated yet.
            // Will be concatenated to `this.resources` in a `Lazy.list`
            // in the constructor instead.
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
BackupSelection[_a] = { fqn: "aws-cdk-lib.aws_backup.BackupSelection", version: "2.74.0" };
exports.BackupSelection = BackupSelection;
//# sourceMappingURL=data:application/json;base64,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