"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomResource = exports.CustomResourceProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("../../core");
/**
 * Represents a provider for an AWS CloudFormation custom resources.
 *
 * @deprecated use core.CustomResource instead
 */
class CustomResourceProvider {
    /**
     * The Lambda provider that implements this custom resource.
     *
     * We recommend using a lambda.SingletonFunction for this.
     */
    static fromLambda(handler) {
        return new CustomResourceProvider(handler.functionArn);
    }
    /**
     * The SNS Topic for the provider that implements this custom resource.
     */
    static fromTopic(topic) {
        return new CustomResourceProvider(topic.topicArn);
    }
    /**
     * Use AWS Lambda as a provider.
     * @deprecated use `fromLambda`
     */
    static lambda(handler) { return this.fromLambda(handler); }
    /**
     * Use an SNS topic as the provider.
     * @deprecated use `fromTopic`
     */
    static topic(topic) { return this.fromTopic(topic); }
    /**
     * @param serviceToken the ServiceToken which contains the ARN for this provider.
     */
    constructor(serviceToken) {
        this.serviceToken = serviceToken;
    }
    bind(_) {
        return { serviceToken: this.serviceToken };
    }
}
_a = JSII_RTTI_SYMBOL_1;
CustomResourceProvider[_a] = { fqn: "aws-cdk-lib.aws_cloudformation.CustomResourceProvider", version: "2.74.0" };
exports.CustomResourceProvider = CustomResourceProvider;
/**
 * Deprecated.
 * @deprecated use `core.CustomResource`
 */
class CustomResource extends core.CustomResource {
    constructor(scope, id, props) {
        super(scope, id, {
            pascalCaseProperties: true,
            properties: props.properties,
            removalPolicy: props.removalPolicy,
            resourceType: props.resourceType,
            serviceToken: core.Lazy.string({ produce: () => props.provider.bind(this).serviceToken }),
        });
    }
}
_b = JSII_RTTI_SYMBOL_1;
CustomResource[_b] = { fqn: "aws-cdk-lib.aws_cloudformation.CustomResource", version: "2.74.0" };
exports.CustomResource = CustomResource;
//# sourceMappingURL=data:application/json;base64,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