"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("../../core");
/**
 * A CloudFormation nested stack.
 *
 * When you apply template changes to update a top-level stack, CloudFormation
 * updates the top-level stack and initiates an update to its nested stacks.
 * CloudFormation updates the resources of modified nested stacks, but does not
 * update the resources of unmodified nested stacks.
 *
 * Furthermore, this stack will not be treated as an independent deployment
 * artifact (won't be listed in "cdk list" or deployable through "cdk deploy"),
 * but rather only synthesized as a template and uploaded as an asset to S3.
 *
 * Cross references of resource attributes between the parent stack and the
 * nested stack will automatically be translated to stack parameters and
 * outputs.
 *
 * @deprecated use core.NestedStack instead
 */
class NestedStack extends core.NestedStack {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            parameters: props.parameters,
            timeout: props.timeout,
            notificationArns: props.notifications?.map(n => n.topicArn),
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
NestedStack[_a] = { fqn: "aws-cdk-lib.aws_cloudformation.NestedStack", version: "2.74.0" };
exports.NestedStack = NestedStack;
//# sourceMappingURL=data:application/json;base64,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