"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancerV2Origin = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const http_origin_1 = require("./http-origin");
/**
 * An Origin for a v2 load balancer.
 */
class LoadBalancerV2Origin extends http_origin_1.HttpOrigin {
    constructor(loadBalancer, props = {}) {
        super(loadBalancer.loadBalancerDnsName, { ...props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ILoadBalancerV2(loadBalancer);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_origins_LoadBalancerV2OriginProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LoadBalancerV2Origin);
            }
            throw error;
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
LoadBalancerV2Origin[_a] = { fqn: "aws-cdk-lib.aws_cloudfront_origins.LoadBalancerV2Origin", version: "2.74.0" };
exports.LoadBalancerV2Origin = LoadBalancerV2Origin;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9hZC1iYWxhbmNlci1vcmlnaW4uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsb2FkLWJhbGFuY2VyLW9yaWdpbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSwrQ0FBNEQ7QUFPNUQ7O0dBRUc7QUFDSCxNQUFhLG9CQUFxQixTQUFRLHdCQUFVO0lBRWxELFlBQVksWUFBbUMsRUFBRSxRQUFtQyxFQUFFO1FBQ3BGLEtBQUssQ0FBQyxZQUFZLENBQUMsbUJBQW1CLEVBQUUsRUFBRSxHQUFHLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7Ozs7K0NBSDdDLG9CQUFvQjs7OztLQUk5Qjs7OztBQUpVLG9EQUFvQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVsYnYyIGZyb20gJy4uLy4uL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyJztcbmltcG9ydCB7IEh0dHBPcmlnaW4sIEh0dHBPcmlnaW5Qcm9wcyB9IGZyb20gJy4vaHR0cC1vcmlnaW4nO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGFuIE9yaWdpbiBiYWNrZWQgYnkgYSB2MiBsb2FkIGJhbGFuY2VyLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIExvYWRCYWxhbmNlclYyT3JpZ2luUHJvcHMgZXh0ZW5kcyBIdHRwT3JpZ2luUHJvcHMgeyB9XG5cbi8qKlxuICogQW4gT3JpZ2luIGZvciBhIHYyIGxvYWQgYmFsYW5jZXIuXG4gKi9cbmV4cG9ydCBjbGFzcyBMb2FkQmFsYW5jZXJWMk9yaWdpbiBleHRlbmRzIEh0dHBPcmlnaW4ge1xuXG4gIGNvbnN0cnVjdG9yKGxvYWRCYWxhbmNlcjogZWxidjIuSUxvYWRCYWxhbmNlclYyLCBwcm9wczogTG9hZEJhbGFuY2VyVjJPcmlnaW5Qcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIobG9hZEJhbGFuY2VyLmxvYWRCYWxhbmNlckRuc05hbWUsIHsgLi4ucHJvcHMgfSk7XG4gIH1cblxufVxuIl19