"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginGroup = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An Origin that represents a group.
 * Consists of a primary Origin,
 * and a fallback Origin called when the primary returns one of the provided HTTP status codes.
 */
class OriginGroup {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_origins_OriginGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, OriginGroup);
            }
            throw error;
        }
    }
    bind(scope, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_OriginBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const primaryOriginConfig = this.props.primaryOrigin.bind(scope, options);
        if (primaryOriginConfig.failoverConfig) {
            throw new Error('An OriginGroup cannot use an Origin with its own failover configuration as its primary origin!');
        }
        return {
            originProperty: primaryOriginConfig.originProperty,
            failoverConfig: {
                failoverOrigin: this.props.fallbackOrigin,
                statusCodes: this.props.fallbackStatusCodes,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
OriginGroup[_a] = { fqn: "aws-cdk-lib.aws_cloudfront_origins.OriginGroup", version: "2.74.0" };
exports.OriginGroup = OriginGroup;
//# sourceMappingURL=data:application/json;base64,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