"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateSecondsInRangeOrUndefined = void 0;
/**
 * Throws an error if a duration is defined and not an integer number of seconds within a range.
 */
function validateSecondsInRangeOrUndefined(name, min, max, duration) {
    if (duration === undefined) {
        return;
    }
    const value = duration.toSeconds();
    if (!Number.isInteger(value) || value < min || value > max) {
        throw new Error(`${name}: Must be an int between ${min} and ${max} seconds (inclusive); received ${value}.`);
    }
}
exports.validateSecondsInRangeOrUndefined = validateSecondsInRangeOrUndefined;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ1dGlscy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFFQTs7R0FFRztBQUNILFNBQWdCLGlDQUFpQyxDQUFDLElBQVksRUFBRSxHQUFXLEVBQUUsR0FBVyxFQUFFLFFBQXVCO0lBQy9HLElBQUksUUFBUSxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU87S0FBRTtJQUN2QyxNQUFNLEtBQUssR0FBRyxRQUFRLENBQUMsU0FBUyxFQUFFLENBQUM7SUFDbkMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLElBQUksS0FBSyxHQUFHLEdBQUcsSUFBSSxLQUFLLEdBQUcsR0FBRyxFQUFFO1FBQzFELE1BQU0sSUFBSSxLQUFLLENBQUMsR0FBRyxJQUFJLDRCQUE0QixHQUFHLFFBQVEsR0FBRyxrQ0FBa0MsS0FBSyxHQUFHLENBQUMsQ0FBQztLQUM5RztBQUNILENBQUM7QUFORCw4RUFNQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICcuLi8uLi8uLi9jb3JlJztcblxuLyoqXG4gKiBUaHJvd3MgYW4gZXJyb3IgaWYgYSBkdXJhdGlvbiBpcyBkZWZpbmVkIGFuZCBub3QgYW4gaW50ZWdlciBudW1iZXIgb2Ygc2Vjb25kcyB3aXRoaW4gYSByYW5nZS5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHZhbGlkYXRlU2Vjb25kc0luUmFuZ2VPclVuZGVmaW5lZChuYW1lOiBzdHJpbmcsIG1pbjogbnVtYmVyLCBtYXg6IG51bWJlciwgZHVyYXRpb24/OiBjZGsuRHVyYXRpb24pIHtcbiAgaWYgKGR1cmF0aW9uID09PSB1bmRlZmluZWQpIHsgcmV0dXJuOyB9XG4gIGNvbnN0IHZhbHVlID0gZHVyYXRpb24udG9TZWNvbmRzKCk7XG4gIGlmICghTnVtYmVyLmlzSW50ZWdlcih2YWx1ZSkgfHwgdmFsdWUgPCBtaW4gfHwgdmFsdWUgPiBtYXgpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoYCR7bmFtZX06IE11c3QgYmUgYW4gaW50IGJldHdlZW4gJHttaW59IGFuZCAke21heH0gc2Vjb25kcyAoaW5jbHVzaXZlKTsgcmVjZWl2ZWQgJHt2YWx1ZX0uYCk7XG4gIH1cbn1cbiJdfQ==