"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestApiOrigin = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudfront = require("../../aws-cloudfront");
const cdk = require("../../core");
const utils_1 = require("./private/utils");
/**
 * An Origin for an API Gateway REST API.
 */
class RestApiOrigin extends cloudfront.OriginBase {
    constructor(restApi, props = {}) {
        // urlForPath() is of the form 'https://<rest-api-id>.execute-api.<region>.amazonaws.com/<stage>'
        // Splitting on '/' gives: ['https', '', '<rest-api-id>.execute-api.<region>.amazonaws.com', '<stage>']
        // The element at index 2 is the domain name, the element at index 3 is the stage name
        super(cdk.Fn.select(2, cdk.Fn.split('/', restApi.url)), {
            originPath: props.originPath ?? `/${cdk.Fn.select(3, cdk.Fn.split('/', restApi.url))}`,
            ...props,
        });
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_RestApi(restApi);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_origins_RestApiOriginProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RestApiOrigin);
            }
            throw error;
        }
        (0, utils_1.validateSecondsInRangeOrUndefined)('readTimeout', 1, 180, props.readTimeout);
        (0, utils_1.validateSecondsInRangeOrUndefined)('keepaliveTimeout', 1, 180, props.keepaliveTimeout);
    }
    renderCustomOriginConfig() {
        return {
            originSslProtocols: [cloudfront.OriginSslPolicy.TLS_V1_2],
            originProtocolPolicy: cloudfront.OriginProtocolPolicy.HTTPS_ONLY,
            originReadTimeout: this.props.readTimeout?.toSeconds(),
            originKeepaliveTimeout: this.props.keepaliveTimeout?.toSeconds(),
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
RestApiOrigin[_a] = { fqn: "aws-cdk-lib.aws_cloudfront_origins.RestApiOrigin", version: "2.74.0" };
exports.RestApiOrigin = RestApiOrigin;
//# sourceMappingURL=data:application/json;base64,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