"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionEventType = exports.Function = exports.FunctionCode = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const core_1 = require("../../core");
const cloudfront_generated_1 = require("./cloudfront.generated");
/**
 * Represents the function's source code
 */
class FunctionCode {
    /**
     * Inline code for function
     * @returns code object with inline code.
     * @param code The actual function code
     */
    static fromInline(code) {
        return new InlineCode(code);
    }
    /**
     * Code from external file for function
     * @returns code object with contents from file.
     * @param options the options for the external file
     */
    static fromFile(options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_FileCodeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromFile);
            }
            throw error;
        }
        return new FileCode(options);
    }
}
_a = JSII_RTTI_SYMBOL_1;
FunctionCode[_a] = { fqn: "aws-cdk-lib.aws_cloudfront.FunctionCode", version: "2.74.0" };
exports.FunctionCode = FunctionCode;
/**
 * Represents the function's source code as inline code
 */
class InlineCode extends FunctionCode {
    constructor(code) {
        super();
        this.code = code;
    }
    render() {
        return this.code;
    }
}
/**
 * Represents the function's source code loaded from an external file
 */
class FileCode extends FunctionCode {
    constructor(options) {
        super();
        this.options = options;
    }
    render() {
        return fs.readFileSync(this.options.filePath, { encoding: 'utf-8' });
    }
}
/**
 * A CloudFront Function
 *
 * @resource AWS::CloudFront::Function
 */
class Function extends core_1.Resource {
    /** Imports a function by its name and ARN */
    static fromFunctionAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_FunctionAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromFunctionAttributes);
            }
            throw error;
        }
        return new class extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.functionName = attrs.functionName;
                this.functionArn = attrs.functionArn;
            }
        }(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_FunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Function);
            }
            throw error;
        }
        this.functionName = props.functionName ?? this.generateName();
        const resource = new cloudfront_generated_1.CfnFunction(this, 'Resource', {
            autoPublish: true,
            functionCode: props.code.render(),
            functionConfig: {
                comment: props.comment ?? this.functionName,
                runtime: 'cloudfront-js-1.0',
            },
            name: this.functionName,
        });
        this.functionArn = resource.attrFunctionArn;
        this.functionStage = resource.attrStage;
    }
    generateName() {
        const name = core_1.Stack.of(this).region + core_1.Names.uniqueId(this);
        if (name.length > 64) {
            return name.substring(0, 32) + name.substring(name.length - 32);
        }
        return name;
    }
}
_b = JSII_RTTI_SYMBOL_1;
Function[_b] = { fqn: "aws-cdk-lib.aws_cloudfront.Function", version: "2.74.0" };
exports.Function = Function;
/**
 * The type of events that a CloudFront function can be invoked in response to.
 */
var FunctionEventType;
(function (FunctionEventType) {
    /**
     * The viewer-request specifies the incoming request
     */
    FunctionEventType["VIEWER_REQUEST"] = "viewer-request";
    /**
     * The viewer-response specifies the outgoing response
     */
    FunctionEventType["VIEWER_RESPONSE"] = "viewer-response";
})(FunctionEventType = exports.FunctionEventType || (exports.FunctionEventType = {}));
//# sourceMappingURL=data:application/json;base64,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