"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublicKey = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const cloudfront_generated_1 = require("./cloudfront.generated");
/**
 * A Public Key Configuration
 *
 * @resource AWS::CloudFront::PublicKey
 */
class PublicKey extends core_1.Resource {
    /** Imports a Public Key from its id. */
    static fromPublicKeyId(scope, id, publicKeyId) {
        return new class extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.publicKeyId = publicKeyId;
            }
        }(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_PublicKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PublicKey);
            }
            throw error;
        }
        if (!core_1.Token.isUnresolved(props.encodedKey) && !/^-----BEGIN PUBLIC KEY-----/.test(props.encodedKey)) {
            throw new Error(`Public key must be in PEM format (with the BEGIN/END PUBLIC KEY lines); got ${props.encodedKey}`);
        }
        const resource = new cloudfront_generated_1.CfnPublicKey(this, 'Resource', {
            publicKeyConfig: {
                name: props.publicKeyName ?? this.generateName(),
                callerReference: this.node.addr,
                encodedKey: props.encodedKey,
                comment: props.comment,
            },
        });
        this.publicKeyId = resource.ref;
    }
    generateName() {
        const name = core_1.Names.uniqueId(this);
        if (name.length > 80) {
            return name.substring(0, 40) + name.substring(name.length - 40);
        }
        return name;
    }
}
_a = JSII_RTTI_SYMBOL_1;
PublicKey[_a] = { fqn: "aws-cdk-lib.aws_cloudfront.PublicKey", version: "2.74.0" };
exports.PublicKey = PublicKey;
//# sourceMappingURL=data:application/json;base64,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