"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTrail = exports.CfnResourcePolicy = exports.CfnEventDataStore = exports.CfnChannel = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnChannelProps`
 *
 * @param properties - the TypeScript properties of a `CfnChannelProps`
 *
 * @returns the result of the validation.
 */
function CfnChannelPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('destinations', cdk.listValidator(CfnChannel_DestinationPropertyValidator))(properties.destinations));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('source', cdk.validateString)(properties.source));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnChannelProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::Channel` resource
 *
 * @param properties - the TypeScript properties of a `CfnChannelProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::Channel` resource.
 */
// @ts-ignore TS6133
function cfnChannelPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannelPropsValidator(properties).assertSuccess();
    return {
        Destinations: cdk.listMapper(cfnChannelDestinationPropertyToCloudFormation)(properties.destinations),
        Name: cdk.stringToCloudFormation(properties.name),
        Source: cdk.stringToCloudFormation(properties.source),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnChannelPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('destinations', 'Destinations', properties.Destinations != null ? cfn_parse.FromCloudFormation.getArray(CfnChannelDestinationPropertyFromCloudFormation)(properties.Destinations) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('source', 'Source', properties.Source != null ? cfn_parse.FromCloudFormation.getString(properties.Source) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::CloudTrail::Channel`
 *
 * Contains information about a returned CloudTrail channel.
 *
 * @cloudformationResource AWS::CloudTrail::Channel
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-channel.html
 */
class CfnChannel extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnChannelPropsFromCloudFormation(resourceProperties);
        const ret = new CfnChannel(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::CloudTrail::Channel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnChannel.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudtrail_CfnChannelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnChannel);
            }
            throw error;
        }
        this.attrChannelArn = cdk.Token.asString(this.getAtt('ChannelArn', cdk.ResolutionTypeHint.STRING));
        this.destinations = props.destinations;
        this.name = props.name;
        this.source = props.source;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::CloudTrail::Channel", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnChannel.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            destinations: this.destinations,
            name: this.name,
            source: this.source,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnChannelPropsToCloudFormation(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
CfnChannel[_a] = { fqn: "aws-cdk-lib.aws_cloudtrail.CfnChannel", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnChannel.CFN_RESOURCE_TYPE_NAME = "AWS::CloudTrail::Channel";
exports.CfnChannel = CfnChannel;
/**
 * Determine whether the given properties match those of a `DestinationProperty`
 *
 * @param properties - the TypeScript properties of a `DestinationProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_DestinationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('location', cdk.requiredValidator)(properties.location));
    errors.collect(cdk.propertyValidator('location', cdk.validateString)(properties.location));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "DestinationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::Channel.Destination` resource
 *
 * @param properties - the TypeScript properties of a `DestinationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::Channel.Destination` resource.
 */
// @ts-ignore TS6133
function cfnChannelDestinationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_DestinationPropertyValidator(properties).assertSuccess();
    return {
        Location: cdk.stringToCloudFormation(properties.location),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnChannelDestinationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('location', 'Location', cfn_parse.FromCloudFormation.getString(properties.Location));
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnEventDataStoreProps`
 *
 * @param properties - the TypeScript properties of a `CfnEventDataStoreProps`
 *
 * @returns the result of the validation.
 */
function CfnEventDataStorePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('advancedEventSelectors', cdk.listValidator(CfnEventDataStore_AdvancedEventSelectorPropertyValidator))(properties.advancedEventSelectors));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('multiRegionEnabled', cdk.validateBoolean)(properties.multiRegionEnabled));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('organizationEnabled', cdk.validateBoolean)(properties.organizationEnabled));
    errors.collect(cdk.propertyValidator('retentionPeriod', cdk.validateNumber)(properties.retentionPeriod));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('terminationProtectionEnabled', cdk.validateBoolean)(properties.terminationProtectionEnabled));
    return errors.wrap('supplied properties not correct for "CfnEventDataStoreProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::EventDataStore` resource
 *
 * @param properties - the TypeScript properties of a `CfnEventDataStoreProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::EventDataStore` resource.
 */
// @ts-ignore TS6133
function cfnEventDataStorePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEventDataStorePropsValidator(properties).assertSuccess();
    return {
        AdvancedEventSelectors: cdk.listMapper(cfnEventDataStoreAdvancedEventSelectorPropertyToCloudFormation)(properties.advancedEventSelectors),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        MultiRegionEnabled: cdk.booleanToCloudFormation(properties.multiRegionEnabled),
        Name: cdk.stringToCloudFormation(properties.name),
        OrganizationEnabled: cdk.booleanToCloudFormation(properties.organizationEnabled),
        RetentionPeriod: cdk.numberToCloudFormation(properties.retentionPeriod),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TerminationProtectionEnabled: cdk.booleanToCloudFormation(properties.terminationProtectionEnabled),
    };
}
// @ts-ignore TS6133
function CfnEventDataStorePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('advancedEventSelectors', 'AdvancedEventSelectors', properties.AdvancedEventSelectors != null ? cfn_parse.FromCloudFormation.getArray(CfnEventDataStoreAdvancedEventSelectorPropertyFromCloudFormation)(properties.AdvancedEventSelectors) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('multiRegionEnabled', 'MultiRegionEnabled', properties.MultiRegionEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiRegionEnabled) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('organizationEnabled', 'OrganizationEnabled', properties.OrganizationEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.OrganizationEnabled) : undefined);
    ret.addPropertyResult('retentionPeriod', 'RetentionPeriod', properties.RetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.RetentionPeriod) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('terminationProtectionEnabled', 'TerminationProtectionEnabled', properties.TerminationProtectionEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.TerminationProtectionEnabled) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::CloudTrail::EventDataStore`
 *
 * Creates a new event data store.
 *
 * @cloudformationResource AWS::CloudTrail::EventDataStore
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html
 */
class CfnEventDataStore extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnEventDataStorePropsFromCloudFormation(resourceProperties);
        const ret = new CfnEventDataStore(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::CloudTrail::EventDataStore`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnEventDataStore.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudtrail_CfnEventDataStoreProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnEventDataStore);
            }
            throw error;
        }
        this.attrCreatedTimestamp = cdk.Token.asString(this.getAtt('CreatedTimestamp', cdk.ResolutionTypeHint.STRING));
        this.attrEventDataStoreArn = cdk.Token.asString(this.getAtt('EventDataStoreArn', cdk.ResolutionTypeHint.STRING));
        this.attrStatus = cdk.Token.asString(this.getAtt('Status', cdk.ResolutionTypeHint.STRING));
        this.attrUpdatedTimestamp = cdk.Token.asString(this.getAtt('UpdatedTimestamp', cdk.ResolutionTypeHint.STRING));
        this.advancedEventSelectors = props.advancedEventSelectors;
        this.kmsKeyId = props.kmsKeyId;
        this.multiRegionEnabled = props.multiRegionEnabled;
        this.name = props.name;
        this.organizationEnabled = props.organizationEnabled;
        this.retentionPeriod = props.retentionPeriod;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::CloudTrail::EventDataStore", props.tags, { tagPropertyName: 'tags' });
        this.terminationProtectionEnabled = props.terminationProtectionEnabled;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnEventDataStore.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            advancedEventSelectors: this.advancedEventSelectors,
            kmsKeyId: this.kmsKeyId,
            multiRegionEnabled: this.multiRegionEnabled,
            name: this.name,
            organizationEnabled: this.organizationEnabled,
            retentionPeriod: this.retentionPeriod,
            tags: this.tags.renderTags(),
            terminationProtectionEnabled: this.terminationProtectionEnabled,
        };
    }
    renderProperties(props) {
        return cfnEventDataStorePropsToCloudFormation(props);
    }
}
_b = JSII_RTTI_SYMBOL_1;
CfnEventDataStore[_b] = { fqn: "aws-cdk-lib.aws_cloudtrail.CfnEventDataStore", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnEventDataStore.CFN_RESOURCE_TYPE_NAME = "AWS::CloudTrail::EventDataStore";
exports.CfnEventDataStore = CfnEventDataStore;
/**
 * Determine whether the given properties match those of a `AdvancedEventSelectorProperty`
 *
 * @param properties - the TypeScript properties of a `AdvancedEventSelectorProperty`
 *
 * @returns the result of the validation.
 */
function CfnEventDataStore_AdvancedEventSelectorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldSelectors', cdk.requiredValidator)(properties.fieldSelectors));
    errors.collect(cdk.propertyValidator('fieldSelectors', cdk.listValidator(CfnEventDataStore_AdvancedFieldSelectorPropertyValidator))(properties.fieldSelectors));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "AdvancedEventSelectorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::EventDataStore.AdvancedEventSelector` resource
 *
 * @param properties - the TypeScript properties of a `AdvancedEventSelectorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::EventDataStore.AdvancedEventSelector` resource.
 */
// @ts-ignore TS6133
function cfnEventDataStoreAdvancedEventSelectorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEventDataStore_AdvancedEventSelectorPropertyValidator(properties).assertSuccess();
    return {
        FieldSelectors: cdk.listMapper(cfnEventDataStoreAdvancedFieldSelectorPropertyToCloudFormation)(properties.fieldSelectors),
        Name: cdk.stringToCloudFormation(properties.name),
    };
}
// @ts-ignore TS6133
function CfnEventDataStoreAdvancedEventSelectorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldSelectors', 'FieldSelectors', cfn_parse.FromCloudFormation.getArray(CfnEventDataStoreAdvancedFieldSelectorPropertyFromCloudFormation)(properties.FieldSelectors));
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AdvancedFieldSelectorProperty`
 *
 * @param properties - the TypeScript properties of a `AdvancedFieldSelectorProperty`
 *
 * @returns the result of the validation.
 */
function CfnEventDataStore_AdvancedFieldSelectorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endsWith', cdk.listValidator(cdk.validateString))(properties.endsWith));
    errors.collect(cdk.propertyValidator('equalTo', cdk.listValidator(cdk.validateString))(properties.equalTo));
    errors.collect(cdk.propertyValidator('field', cdk.requiredValidator)(properties.field));
    errors.collect(cdk.propertyValidator('field', cdk.validateString)(properties.field));
    errors.collect(cdk.propertyValidator('notEndsWith', cdk.listValidator(cdk.validateString))(properties.notEndsWith));
    errors.collect(cdk.propertyValidator('notEquals', cdk.listValidator(cdk.validateString))(properties.notEquals));
    errors.collect(cdk.propertyValidator('notStartsWith', cdk.listValidator(cdk.validateString))(properties.notStartsWith));
    errors.collect(cdk.propertyValidator('startsWith', cdk.listValidator(cdk.validateString))(properties.startsWith));
    return errors.wrap('supplied properties not correct for "AdvancedFieldSelectorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::EventDataStore.AdvancedFieldSelector` resource
 *
 * @param properties - the TypeScript properties of a `AdvancedFieldSelectorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::EventDataStore.AdvancedFieldSelector` resource.
 */
// @ts-ignore TS6133
function cfnEventDataStoreAdvancedFieldSelectorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEventDataStore_AdvancedFieldSelectorPropertyValidator(properties).assertSuccess();
    return {
        EndsWith: cdk.listMapper(cdk.stringToCloudFormation)(properties.endsWith),
        Equals: cdk.listMapper(cdk.stringToCloudFormation)(properties.equalTo),
        Field: cdk.stringToCloudFormation(properties.field),
        NotEndsWith: cdk.listMapper(cdk.stringToCloudFormation)(properties.notEndsWith),
        NotEquals: cdk.listMapper(cdk.stringToCloudFormation)(properties.notEquals),
        NotStartsWith: cdk.listMapper(cdk.stringToCloudFormation)(properties.notStartsWith),
        StartsWith: cdk.listMapper(cdk.stringToCloudFormation)(properties.startsWith),
    };
}
// @ts-ignore TS6133
function CfnEventDataStoreAdvancedFieldSelectorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endsWith', 'EndsWith', properties.EndsWith != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EndsWith) : undefined);
    ret.addPropertyResult('equalTo', 'Equals', properties.Equals != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Equals) : undefined);
    ret.addPropertyResult('field', 'Field', cfn_parse.FromCloudFormation.getString(properties.Field));
    ret.addPropertyResult('notEndsWith', 'NotEndsWith', properties.NotEndsWith != null ? cfn_parse.FromCloudFormation.getStringArray(properties.NotEndsWith) : undefined);
    ret.addPropertyResult('notEquals', 'NotEquals', properties.NotEquals != null ? cfn_parse.FromCloudFormation.getStringArray(properties.NotEquals) : undefined);
    ret.addPropertyResult('notStartsWith', 'NotStartsWith', properties.NotStartsWith != null ? cfn_parse.FromCloudFormation.getStringArray(properties.NotStartsWith) : undefined);
    ret.addPropertyResult('startsWith', 'StartsWith', properties.StartsWith != null ? cfn_parse.FromCloudFormation.getStringArray(properties.StartsWith) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnResourcePolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnResourcePolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnResourcePolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('resourceArn', cdk.requiredValidator)(properties.resourceArn));
    errors.collect(cdk.propertyValidator('resourceArn', cdk.validateString)(properties.resourceArn));
    errors.collect(cdk.propertyValidator('resourcePolicy', cdk.requiredValidator)(properties.resourcePolicy));
    errors.collect(cdk.propertyValidator('resourcePolicy', cdk.validateObject)(properties.resourcePolicy));
    return errors.wrap('supplied properties not correct for "CfnResourcePolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::ResourcePolicy` resource
 *
 * @param properties - the TypeScript properties of a `CfnResourcePolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::ResourcePolicy` resource.
 */
// @ts-ignore TS6133
function cfnResourcePolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResourcePolicyPropsValidator(properties).assertSuccess();
    return {
        ResourceArn: cdk.stringToCloudFormation(properties.resourceArn),
        ResourcePolicy: cdk.objectToCloudFormation(properties.resourcePolicy),
    };
}
// @ts-ignore TS6133
function CfnResourcePolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('resourceArn', 'ResourceArn', cfn_parse.FromCloudFormation.getString(properties.ResourceArn));
    ret.addPropertyResult('resourcePolicy', 'ResourcePolicy', cfn_parse.FromCloudFormation.getAny(properties.ResourcePolicy));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::CloudTrail::ResourcePolicy`
 *
 * Attaches a resource-based permission policy to a CloudTrail channel that is used for an integration with an event source outside of AWS . For more information about resource-based policies, see [CloudTrail resource-based policy examples](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html) in the *CloudTrail User Guide* .
 *
 * @cloudformationResource AWS::CloudTrail::ResourcePolicy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-resourcepolicy.html
 */
class CfnResourcePolicy extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnResourcePolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnResourcePolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::CloudTrail::ResourcePolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnResourcePolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudtrail_CfnResourcePolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnResourcePolicy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'resourceArn', this);
        cdk.requireProperty(props, 'resourcePolicy', this);
        this.resourceArn = props.resourceArn;
        this.resourcePolicy = props.resourcePolicy;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnResourcePolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            resourceArn: this.resourceArn,
            resourcePolicy: this.resourcePolicy,
        };
    }
    renderProperties(props) {
        return cfnResourcePolicyPropsToCloudFormation(props);
    }
}
_c = JSII_RTTI_SYMBOL_1;
CfnResourcePolicy[_c] = { fqn: "aws-cdk-lib.aws_cloudtrail.CfnResourcePolicy", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnResourcePolicy.CFN_RESOURCE_TYPE_NAME = "AWS::CloudTrail::ResourcePolicy";
exports.CfnResourcePolicy = CfnResourcePolicy;
/**
 * Determine whether the given properties match those of a `CfnTrailProps`
 *
 * @param properties - the TypeScript properties of a `CfnTrailProps`
 *
 * @returns the result of the validation.
 */
function CfnTrailPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cloudWatchLogsLogGroupArn', cdk.validateString)(properties.cloudWatchLogsLogGroupArn));
    errors.collect(cdk.propertyValidator('cloudWatchLogsRoleArn', cdk.validateString)(properties.cloudWatchLogsRoleArn));
    errors.collect(cdk.propertyValidator('enableLogFileValidation', cdk.validateBoolean)(properties.enableLogFileValidation));
    errors.collect(cdk.propertyValidator('eventSelectors', cdk.listValidator(CfnTrail_EventSelectorPropertyValidator))(properties.eventSelectors));
    errors.collect(cdk.propertyValidator('includeGlobalServiceEvents', cdk.validateBoolean)(properties.includeGlobalServiceEvents));
    errors.collect(cdk.propertyValidator('insightSelectors', cdk.listValidator(CfnTrail_InsightSelectorPropertyValidator))(properties.insightSelectors));
    errors.collect(cdk.propertyValidator('isLogging', cdk.requiredValidator)(properties.isLogging));
    errors.collect(cdk.propertyValidator('isLogging', cdk.validateBoolean)(properties.isLogging));
    errors.collect(cdk.propertyValidator('isMultiRegionTrail', cdk.validateBoolean)(properties.isMultiRegionTrail));
    errors.collect(cdk.propertyValidator('isOrganizationTrail', cdk.validateBoolean)(properties.isOrganizationTrail));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('s3BucketName', cdk.requiredValidator)(properties.s3BucketName));
    errors.collect(cdk.propertyValidator('s3BucketName', cdk.validateString)(properties.s3BucketName));
    errors.collect(cdk.propertyValidator('s3KeyPrefix', cdk.validateString)(properties.s3KeyPrefix));
    errors.collect(cdk.propertyValidator('snsTopicName', cdk.validateString)(properties.snsTopicName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('trailName', cdk.validateString)(properties.trailName));
    return errors.wrap('supplied properties not correct for "CfnTrailProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::Trail` resource
 *
 * @param properties - the TypeScript properties of a `CfnTrailProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::Trail` resource.
 */
// @ts-ignore TS6133
function cfnTrailPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTrailPropsValidator(properties).assertSuccess();
    return {
        IsLogging: cdk.booleanToCloudFormation(properties.isLogging),
        S3BucketName: cdk.stringToCloudFormation(properties.s3BucketName),
        CloudWatchLogsLogGroupArn: cdk.stringToCloudFormation(properties.cloudWatchLogsLogGroupArn),
        CloudWatchLogsRoleArn: cdk.stringToCloudFormation(properties.cloudWatchLogsRoleArn),
        EnableLogFileValidation: cdk.booleanToCloudFormation(properties.enableLogFileValidation),
        EventSelectors: cdk.listMapper(cfnTrailEventSelectorPropertyToCloudFormation)(properties.eventSelectors),
        IncludeGlobalServiceEvents: cdk.booleanToCloudFormation(properties.includeGlobalServiceEvents),
        InsightSelectors: cdk.listMapper(cfnTrailInsightSelectorPropertyToCloudFormation)(properties.insightSelectors),
        IsMultiRegionTrail: cdk.booleanToCloudFormation(properties.isMultiRegionTrail),
        IsOrganizationTrail: cdk.booleanToCloudFormation(properties.isOrganizationTrail),
        KMSKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        S3KeyPrefix: cdk.stringToCloudFormation(properties.s3KeyPrefix),
        SnsTopicName: cdk.stringToCloudFormation(properties.snsTopicName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TrailName: cdk.stringToCloudFormation(properties.trailName),
    };
}
// @ts-ignore TS6133
function CfnTrailPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('isLogging', 'IsLogging', cfn_parse.FromCloudFormation.getBoolean(properties.IsLogging));
    ret.addPropertyResult('s3BucketName', 'S3BucketName', cfn_parse.FromCloudFormation.getString(properties.S3BucketName));
    ret.addPropertyResult('cloudWatchLogsLogGroupArn', 'CloudWatchLogsLogGroupArn', properties.CloudWatchLogsLogGroupArn != null ? cfn_parse.FromCloudFormation.getString(properties.CloudWatchLogsLogGroupArn) : undefined);
    ret.addPropertyResult('cloudWatchLogsRoleArn', 'CloudWatchLogsRoleArn', properties.CloudWatchLogsRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.CloudWatchLogsRoleArn) : undefined);
    ret.addPropertyResult('enableLogFileValidation', 'EnableLogFileValidation', properties.EnableLogFileValidation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableLogFileValidation) : undefined);
    ret.addPropertyResult('eventSelectors', 'EventSelectors', properties.EventSelectors != null ? cfn_parse.FromCloudFormation.getArray(CfnTrailEventSelectorPropertyFromCloudFormation)(properties.EventSelectors) : undefined);
    ret.addPropertyResult('includeGlobalServiceEvents', 'IncludeGlobalServiceEvents', properties.IncludeGlobalServiceEvents != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeGlobalServiceEvents) : undefined);
    ret.addPropertyResult('insightSelectors', 'InsightSelectors', properties.InsightSelectors != null ? cfn_parse.FromCloudFormation.getArray(CfnTrailInsightSelectorPropertyFromCloudFormation)(properties.InsightSelectors) : undefined);
    ret.addPropertyResult('isMultiRegionTrail', 'IsMultiRegionTrail', properties.IsMultiRegionTrail != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IsMultiRegionTrail) : undefined);
    ret.addPropertyResult('isOrganizationTrail', 'IsOrganizationTrail', properties.IsOrganizationTrail != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IsOrganizationTrail) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KMSKeyId', properties.KMSKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KMSKeyId) : undefined);
    ret.addPropertyResult('s3KeyPrefix', 'S3KeyPrefix', properties.S3KeyPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.S3KeyPrefix) : undefined);
    ret.addPropertyResult('snsTopicName', 'SnsTopicName', properties.SnsTopicName != null ? cfn_parse.FromCloudFormation.getString(properties.SnsTopicName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('trailName', 'TrailName', properties.TrailName != null ? cfn_parse.FromCloudFormation.getString(properties.TrailName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::CloudTrail::Trail`
 *
 * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
 *
 * @cloudformationResource AWS::CloudTrail::Trail
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html
 */
class CfnTrail extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnTrailPropsFromCloudFormation(resourceProperties);
        const ret = new CfnTrail(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::CloudTrail::Trail`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTrail.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudtrail_CfnTrailProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnTrail);
            }
            throw error;
        }
        cdk.requireProperty(props, 'isLogging', this);
        cdk.requireProperty(props, 's3BucketName', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrSnsTopicArn = cdk.Token.asString(this.getAtt('SnsTopicArn', cdk.ResolutionTypeHint.STRING));
        this.isLogging = props.isLogging;
        this.s3BucketName = props.s3BucketName;
        this.cloudWatchLogsLogGroupArn = props.cloudWatchLogsLogGroupArn;
        this.cloudWatchLogsRoleArn = props.cloudWatchLogsRoleArn;
        this.enableLogFileValidation = props.enableLogFileValidation;
        this.eventSelectors = props.eventSelectors;
        this.includeGlobalServiceEvents = props.includeGlobalServiceEvents;
        this.insightSelectors = props.insightSelectors;
        this.isMultiRegionTrail = props.isMultiRegionTrail;
        this.isOrganizationTrail = props.isOrganizationTrail;
        this.kmsKeyId = props.kmsKeyId;
        this.s3KeyPrefix = props.s3KeyPrefix;
        this.snsTopicName = props.snsTopicName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::CloudTrail::Trail", props.tags, { tagPropertyName: 'tags' });
        this.trailName = props.trailName;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnTrail.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            isLogging: this.isLogging,
            s3BucketName: this.s3BucketName,
            cloudWatchLogsLogGroupArn: this.cloudWatchLogsLogGroupArn,
            cloudWatchLogsRoleArn: this.cloudWatchLogsRoleArn,
            enableLogFileValidation: this.enableLogFileValidation,
            eventSelectors: this.eventSelectors,
            includeGlobalServiceEvents: this.includeGlobalServiceEvents,
            insightSelectors: this.insightSelectors,
            isMultiRegionTrail: this.isMultiRegionTrail,
            isOrganizationTrail: this.isOrganizationTrail,
            kmsKeyId: this.kmsKeyId,
            s3KeyPrefix: this.s3KeyPrefix,
            snsTopicName: this.snsTopicName,
            tags: this.tags.renderTags(),
            trailName: this.trailName,
        };
    }
    renderProperties(props) {
        return cfnTrailPropsToCloudFormation(props);
    }
}
_d = JSII_RTTI_SYMBOL_1;
CfnTrail[_d] = { fqn: "aws-cdk-lib.aws_cloudtrail.CfnTrail", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnTrail.CFN_RESOURCE_TYPE_NAME = "AWS::CloudTrail::Trail";
exports.CfnTrail = CfnTrail;
/**
 * Determine whether the given properties match those of a `DataResourceProperty`
 *
 * @param properties - the TypeScript properties of a `DataResourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnTrail_DataResourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "DataResourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::Trail.DataResource` resource
 *
 * @param properties - the TypeScript properties of a `DataResourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::Trail.DataResource` resource.
 */
// @ts-ignore TS6133
function cfnTrailDataResourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTrail_DataResourcePropertyValidator(properties).assertSuccess();
    return {
        Type: cdk.stringToCloudFormation(properties.type),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnTrailDataResourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EventSelectorProperty`
 *
 * @param properties - the TypeScript properties of a `EventSelectorProperty`
 *
 * @returns the result of the validation.
 */
function CfnTrail_EventSelectorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataResources', cdk.listValidator(CfnTrail_DataResourcePropertyValidator))(properties.dataResources));
    errors.collect(cdk.propertyValidator('excludeManagementEventSources', cdk.listValidator(cdk.validateString))(properties.excludeManagementEventSources));
    errors.collect(cdk.propertyValidator('includeManagementEvents', cdk.validateBoolean)(properties.includeManagementEvents));
    errors.collect(cdk.propertyValidator('readWriteType', cdk.validateString)(properties.readWriteType));
    return errors.wrap('supplied properties not correct for "EventSelectorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::Trail.EventSelector` resource
 *
 * @param properties - the TypeScript properties of a `EventSelectorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::Trail.EventSelector` resource.
 */
// @ts-ignore TS6133
function cfnTrailEventSelectorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTrail_EventSelectorPropertyValidator(properties).assertSuccess();
    return {
        DataResources: cdk.listMapper(cfnTrailDataResourcePropertyToCloudFormation)(properties.dataResources),
        ExcludeManagementEventSources: cdk.listMapper(cdk.stringToCloudFormation)(properties.excludeManagementEventSources),
        IncludeManagementEvents: cdk.booleanToCloudFormation(properties.includeManagementEvents),
        ReadWriteType: cdk.stringToCloudFormation(properties.readWriteType),
    };
}
// @ts-ignore TS6133
function CfnTrailEventSelectorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataResources', 'DataResources', properties.DataResources != null ? cfn_parse.FromCloudFormation.getArray(CfnTrailDataResourcePropertyFromCloudFormation)(properties.DataResources) : undefined);
    ret.addPropertyResult('excludeManagementEventSources', 'ExcludeManagementEventSources', properties.ExcludeManagementEventSources != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ExcludeManagementEventSources) : undefined);
    ret.addPropertyResult('includeManagementEvents', 'IncludeManagementEvents', properties.IncludeManagementEvents != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeManagementEvents) : undefined);
    ret.addPropertyResult('readWriteType', 'ReadWriteType', properties.ReadWriteType != null ? cfn_parse.FromCloudFormation.getString(properties.ReadWriteType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InsightSelectorProperty`
 *
 * @param properties - the TypeScript properties of a `InsightSelectorProperty`
 *
 * @returns the result of the validation.
 */
function CfnTrail_InsightSelectorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('insightType', cdk.validateString)(properties.insightType));
    return errors.wrap('supplied properties not correct for "InsightSelectorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::Trail.InsightSelector` resource
 *
 * @param properties - the TypeScript properties of a `InsightSelectorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::Trail.InsightSelector` resource.
 */
// @ts-ignore TS6133
function cfnTrailInsightSelectorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTrail_InsightSelectorPropertyValidator(properties).assertSuccess();
    return {
        InsightType: cdk.stringToCloudFormation(properties.insightType),
    };
}
// @ts-ignore TS6133
function CfnTrailInsightSelectorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('insightType', 'InsightType', properties.InsightType != null ? cfn_parse.FromCloudFormation.getString(properties.InsightType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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