"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationScalingAction = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an ApplicationAutoScaling StepScalingAction as an Alarm Action
 */
class ApplicationScalingAction {
    constructor(stepScalingAction) {
        this.stepScalingAction = stepScalingAction;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_applicationautoscaling_StepScalingAction(stepScalingAction);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApplicationScalingAction);
            }
            throw error;
        }
    }
    /**
     * Returns an alarm action configuration to use an ApplicationScaling StepScalingAction
     * as an alarm action
     */
    bind(_scope, _alarm) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_IAlarm(_alarm);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return { alarmActionArn: this.stepScalingAction.scalingPolicyArn };
    }
}
_a = JSII_RTTI_SYMBOL_1;
ApplicationScalingAction[_a] = { fqn: "aws-cdk-lib.aws_cloudwatch_actions.ApplicationScalingAction", version: "2.74.0" };
exports.ApplicationScalingAction = ApplicationScalingAction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwc2NhbGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwcHNjYWxpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBSUE7O0dBRUc7QUFDSCxNQUFhLHdCQUF3QjtJQUNuQyxZQUE2QixpQkFBK0M7UUFBL0Msc0JBQWlCLEdBQWpCLGlCQUFpQixDQUE4Qjs7Ozs7OytDQURqRSx3QkFBd0I7Ozs7S0FFbEM7SUFFRDs7O09BR0c7SUFDSSxJQUFJLENBQUMsTUFBaUIsRUFBRSxNQUF5Qjs7Ozs7Ozs7OztRQUN0RCxPQUFPLEVBQUUsY0FBYyxFQUFFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO0tBQ3BFOzs7O0FBVlUsNERBQXdCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgYXBwc2NhbGluZyBmcm9tICcuLi8uLi9hd3MtYXBwbGljYXRpb25hdXRvc2NhbGluZyc7XG5pbXBvcnQgKiBhcyBjbG91ZHdhdGNoIGZyb20gJy4uLy4uL2F3cy1jbG91ZHdhdGNoJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vKipcbiAqIFVzZSBhbiBBcHBsaWNhdGlvbkF1dG9TY2FsaW5nIFN0ZXBTY2FsaW5nQWN0aW9uIGFzIGFuIEFsYXJtIEFjdGlvblxuICovXG5leHBvcnQgY2xhc3MgQXBwbGljYXRpb25TY2FsaW5nQWN0aW9uIGltcGxlbWVudHMgY2xvdWR3YXRjaC5JQWxhcm1BY3Rpb24ge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHN0ZXBTY2FsaW5nQWN0aW9uOiBhcHBzY2FsaW5nLlN0ZXBTY2FsaW5nQWN0aW9uKSB7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhbiBhbGFybSBhY3Rpb24gY29uZmlndXJhdGlvbiB0byB1c2UgYW4gQXBwbGljYXRpb25TY2FsaW5nIFN0ZXBTY2FsaW5nQWN0aW9uXG4gICAqIGFzIGFuIGFsYXJtIGFjdGlvblxuICAgKi9cbiAgcHVibGljIGJpbmQoX3Njb3BlOiBDb25zdHJ1Y3QsIF9hbGFybTogY2xvdWR3YXRjaC5JQWxhcm0pOiBjbG91ZHdhdGNoLkFsYXJtQWN0aW9uQ29uZmlnIHtcbiAgICByZXR1cm4geyBhbGFybUFjdGlvbkFybjogdGhpcy5zdGVwU2NhbGluZ0FjdGlvbi5zY2FsaW5nUG9saWN5QXJuIH07XG4gIH1cbn1cbiJdfQ==